
import sys,os,urllib,py_compile,time,string
from unix_base import *

def install_execute(pac,command):
	if not ask_to_execute(command):
		print '['+pac+'] not installed.'
		sys.exit()

class OldPackage:
	'Represents a fetchable, installable, removable package.'
	def __init__(self,name,description,url,doc,cache,source,systems,depends,\
	             exists,inpath,bins,paths,enviros,daemons,inst,setup,demo):
		self.name           = name
		self.description    = description
		self.url            = url
		self.doc            = doc
		self.cache          = cache
		self.source         = source
		self.systems        = systems
		self.depends        = depends
		self.exists         = exists 
		self.inpath         = inpath
		self.bins           = bins
		self.paths          = paths
		self.enviros        = enviros
		self.daemons        = daemons
		self.fetchtime      = time.time()
		self.fetched        = 0
		self.installed      = 0
		self.install_extra  = inst
		self.uninstall_coms = []
		self.setup          = setup
		self.demo           = demo

	def equiv(self,p):
		if self.name             == p.name           and \
		   self.description      == p.description    and \
		   self.url              == p.url            and \
		   self.doc              == p.doc            and \
		   self.cache            == p.cache          and \
		   self.source           == p.source         and \
		   self.systems          == p.systems        and \
		   self.depends          == p.depends        and \
		   self.exists           == p.exists         and \
		   self.inpath           == p.inpath         and \
		   self.bins             == p.bins           and \
		   self.paths            == p.paths          and \
		   self.enviros          == p.enviros        and \
		   self.daemons          == p.daemons        and \
		   self.install_extra    == p.install_extra  and \
		   self.setup            == p.setup          and \
		   self.demo             == p.demo: return 1
		else:
			return 0
		
	def display(self):
		def daemon_status_print(daemon):
			psf = os.popen('ps -edalf').readlines()
			l = len(daemon)
			for line in psf:
				if daemon == line[len(line)-1-l:len(line)-1]: return 'RUNNING'
			return 'NOT RUNNING'
			
		print '                          name:  ',self.name
		print '                    decription:  ',self.description
		print '                           URL:  ',self.url
		print '                    local docs:  ',self.doc
		print '                         cache:  ',self.cache
		print '                        source:  ',self.source
		print '                  time fetched:  ',time.ctime(self.fetchtime)
		print '                       systems:  ',self.systems
		print '                    depends on:  ',self.depends
		print '     files required to install:  ',self.exists
		print '     binaries in path required:  ',self.inpath
		print '                      binaries:  ',self.bins
		for daemon in self.daemons:
			print ( '                        daemon:  '+daemon+': '+daemon_status_print(daemon) )
		print '                         paths:  ',self.paths
		print '         environment variables:  ',self.enviros
		print '                      fetched?:  ',yesno(self.fetched)
		print '                    installed?:  ',yesno(self.installed)
		print '        extra install commands:  ',self.install_extra
		print '            uninstall commands:  ',self.uninstall_coms
		print '                  demo command:  ',self.demo
		
	def fetch(self,pdb,pg):
		if self.fetched:
			pass
		elif self.source=='' or self.systems.has_key(sys.platform) or self.systems.has_key('*'):
			if   self.source=='':           file = ''
			elif self.systems.has_key('*'): file = self.systems['*'][0]
			else:                           file = self.systems[sys.platform][0]
		
			for pac in self.depends:
				p = pg.get(pac)
				p.fetch(pdb,pg)
			
			if self.source == '':
				print 'Fetching ['+self.name+']...'
			else:
#				file = self.systems[sys.platform][0]
				print 'Fetching ['+fncat(self.source,file)+']...'
				try:		
					urllib.urlretrieve(fncat(self.source,file),file)
				except IOError:
					print '** Error fetching ['+file+'] from ['+self.source+'].'
					print '** ['+self.name+'] not fetched.'
					sys.exit()
				
			self.fetched = 1
			self.fetchtime = time.time()
		else:
			print "Package ["+self.name+"] isn't available for ["+sys.platform+"]."
			self.fetched = 0
			sys.exit()
			
		pdb[self.name] = self
		return pdb

	def install(self,pdb):
		if not self.fetched:
			print 'You much -fetch ['+self.name+'] before installing it.'
			sys.exit()
		elif self.installed: 
			pass
		elif self.source=='' or self.systems.has_key(sys.platform) or self.systems.has_key('*'):
			for pac in self.depends:
				if pdb.has_key(pac): pdb = pdb[pac].install(pdb)
				else: 
					print "Can't install ["+pac+"].  It hasn't been fetched."
					sys.exit()

			for fi in self.exists:
				if not os.path.exists(os.path.expanduser(fi)):
					print 'File ['+fi+'] is missing.  It is required to install ['+self.name+'].'
					sys.exit()
				elif verbose:
					print 'Checking that file ['+fi+'] exists.  OK...'
					
			for pa in self.inpath:
				if not os.system('which '+pa) == 0:
					print '['+pa+'] must be in $PATH to install ['+self.name+'].'
					sys.exit()
				elif verbose:
					print 'Checking that ['+pa+'] is in $PATH.  OK...'
					
			if      len(self.install_extra.keys()) == 0: commands = []
			elif self.install_extra.has_key(username()): commands = self.install_extra[username()]
			elif self.install_extra.has_key('*'):        commands = self.install_extra['*']
			else:
				print 'Your username must be on this list to install ['+self.name+']:'
				for login in self.install_extra.keys(): print '      ',login
				sys.exit()

			if not self.source=='':
				if self.systems.has_key('*'): 
					file = self.systems['*'         ][0]
					root = self.systems['*'         ][1]
				else:
					file = self.systems[sys.platform][0]
					root = self.systems[sys.platform][1]
					
				while 1:
					if    tail(file,'.gz'):
						install_execute(self.name,'gunzip '+file)
						file = file[:len(file)-3]
						self.uninstall_coms.insert(0,'gzip '+file)
					elif  tail(file,'.Z'):
						install_execute(self.name,'gunzip '+file)
						file = file[:len(file)-2]
						self.uninstall_coms.insert(0,'compress '+file)
					elif  tail(file,'.tgz'):
						install_execute(self.name,'gunzip '+file)
						file = file[:len(file)-4]+'.tar'
						self.uninstall_coms.insert(0,'gzip '+file)
					elif  tail(file,'.tar'):
						install_execute(self.name,'tar xvPf '+file)
						self.uninstall_coms.insert(0,'rm -r -f '+root)
						file = file[:len(file)-4]
					elif tail(file,'.rpm'):
						if (not switch('no-rpmcheck')): install_execute(self.name,'rpm --checksig '+file)
						if rpm_replace(self.name):
							install_execute(self.name,'rpm -U --force '+file)
							self.uninstall_coms.insert(0,'rpm -e --nodeps '+self.name)
						else:
							install_execute(self.name,'rpm -U '+file)
							self.uninstall_coms.insert(0,'rpm -e --nodeps '+self.name)
						break
					else:
						break
			
			self.set_enviros()
			self.add_to_paths()
			if not self.source=='':
				for command in commands: install_execute(self.name,'cd '+root+'; '+command)
			else:
				for command in commands: install_execute(self.name,command)
			for bin in self.bins: 
				if is_root(): 
					if os.path.exists(bin):
						print 'Copying ['+bin+'] to /usr/local/bin...'
						install_execute(self.name,'cp '+bin+' /usr/local/bin')
						self.uninstall_coms.insert(0,'rm -f /usr/local/bin/'+os.path.basename(bin))
					else:
						print '** binary or shell script ['+bin+'] does not exist.'
						print '** ['+self.name+'] not installed.'
						sys.exit()			
			self.installed = 1
		else:
			print 'Your system type is: ['+sys.platform+'].'
			print '['+self.name+'] can only be installed on one of these systems:'
			for plat in self.systems.keys(): print '     ',plat
			sys.exit()

		pdb[self.name] = self
		return pdb		

	def uninstall(self,pdb):
		if not self.installed:
			pass
		else:
			if not switch('no-recursive'):
				for pac in self.depends:
					if pdb.has_key(pac): pdb[pac].uninstall(pdb)
				
			for com in self.uninstall_coms: ask_to_execute(com)
			self.installed = 0
			self.uninstall_coms = []
		pdb[self.name] = self
		return pdb
		
	def remove(self,pdb):
		if not switch('no-recursive'):
			for pac in self.depends:
				if pdb.has_key(pac): pdb = pdb[pac].remove(pdb)
			
		if self.installed: self.uninstall(pdb)
		if self.fetched and self.systems.has_key(sys.platform):
			file = self.systems[sys.platform][0]
			if os.path.exists(file): ask_to_execute('rm -r '+file)
			
		del pdb[self.name]
		return pdb
			
	def set_enviros(self):
                if self.systems.has_key('*'):
                        root = self.systems['*'][1]
                elif self.systems.has_key(sys.platform):
                        root = self.systems[sys.platform][1]
                else:
                        root = ''
		
		for env in self.enviros:
			if len(env[1])>2:
				if env[1][0:1]=='|' and env[1][-1]=='|':
					val = env[1][1:-1]
				else:
					val = fncat(fncat(os.getcwd(),root),env[1])
			else:
				val = fncat(fncat(os.getcwd(),root),env[1])
			
#			os.environ[env[0]] = fncat(fncat(os.getcwd(),root),env[1])
			os.environ[env[0]] = val
			if verbose: print 'Setting environment variable ['+env[0]+'] to ['+os.environ[env[0]]+'].'

	def add_to_paths(self):
                if self.systems.has_key('*'):
                        root = self.systems['*'][1]
                elif self.systems.has_key(sys.platform):
                        root = self.systems[sys.platform][1]
                else:
                        root = ''
			
		for path in self.paths:
			pathval = fncat(fncat(os.getcwd(),root),path[1])
			
			if not os.environ.has_key(path[0]):
				os.environ[path[0]] = pathval
				if verbose: print 'Setting ['+path[0]+'] to ['+pathval+'].'
			elif not substr(pathval,os.environ[path[0]]):
				os.environ[path[0]] = os.environ[path[0]]+':'+pathval
				if verbose: print 'Adding ['+pathval+'] to path variable ['+path[0]+'].'
