#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/errno.h>
#include "camlib.h"
#include "TFile.h"
#include "TH1.h"
#include "TH2.h"
#include "TProfile.h"
//#include "TRandom.h"


#define NELR 1      /* station number of Event LAM Registar*/
#define ELR_A 0     /* ELR subaddress */
#define NTRIG NELR  /* trigger module */

#define ADC_MOD 3      /* station number of ADC Module */ 
#define ADC_CH_START 3  /* ADC channel */
#define ADC_CH_END 3    /* ADC channel */

#define CRATEID 0  /* CAMAC Crate ID */



/* prototypes */
int SysInit();
int UserInit();
void UserStart();
int UserTrigger(int n,int a);
int ReadAdc();
void ClearModule();
void UserTerm();
void SysTerm();
void UserEnd();

/*** main recorder process ***/
int main(int argc ,char *argv[]){

  int event_num;
  int jevt;
  int data;
  /* usage information */
  if(argc!=2){
      fprintf(stderr," usage : ./daqtest [number of events]\n");
      exit (1);
  }

  /* how many event to acqmulate */
  if(argc==2){
    event_num = atoi(argv[1]);
  }
  else{
    event_num = 100;
  }


  /* Initialize CAMAC */
  
   
  if(!SysInit()){
    printf(" error : cannot initialize CAMAC.\n");
    return 1;
  }
  

  UserInit();
  UserStart();
  TFile hfile("daqtest.root","RECREATE","daqtest ROOT file with histograms");
  TH1F *hadc   = new TH1F("hadc","This is adc  distribution",100,0,500);
  
  fprintf(stderr,"data gathering start!\n");


  /* gather data */
  for(jevt=0;jevt<event_num;jevt++){
    while(UserTrigger(NTRIG,ELR_A)!=1){
      ;
    }
    fprintf(stdout,"%d ",jevt+1);
    data = ReadAdc();     /* read ADC */ 
    hadc->Fill(Float_t(data));
    ClearModule();  /* clear ADC and ELR */
  }

  /* terminate process */
  UserEnd();
  UserTerm();
  SysTerm();

  /* end program */
  fprintf(stderr," Finished data gathering!\n");

  return 0;

}

/*** CAMAC Initialiize ***/
int SysInit(){
   	if(COPEN()){
    return 0;
  }
  
  CSETCR(CRATEID);
  CGENZ();
  CGENC();
  CREMI();

  return 1;
}


/*** initialize by user ***/
int UserInit(){
  return 1;
}


/*** user start ***/
void UserStart(){
	
  int data,q,x;

  CAMAC(NAF(NELR,ELR_A,25),&data,&q,&x);   /* execute */
  CAMAC(NAF(NELR,ELR_A,24),&data,&q,&x);   /* disable */
  CAMAC(NAF(NELR,1,9),&data,&q,&x);        /* clear */
  CAMAC(NAF(ADC_MOD,0,9),&data,&q,&x);     /* Clear ADC */
  CAMAC(NAF(NELR,ELR_A,26),&data,&q,&x);   /* enable ELR */
  CAMAC(NAF(NELR,ELR_A,9),&data,&q,&x);    /* Clear ELR */
}


/*** user trigger ***/
int UserTrigger(int n,int a){
	
  int data,q,x;
  CAMAC(NAF(n,a,8),&data,&q,&x);   /* look at me */
  return q;


}


/*** ADC read ***/
int ReadAdc(){
	
  int data,q,x;
  int read_adc;
  int i;

  for(i=ADC_CH_START;i<=ADC_CH_END;i++){
      read_adc = NAF(ADC_MOD,i,0);
      do{
          CAMAC(read_adc,&data,&q,&x);
      }
      while(q==0);
      
      fprintf(stdout,"%d ",data);
  }

  fprintf(stdout,"\n");

  return data;
}


/*** clear ELR and ADC ***/
void ClearModule(){
  int data,q,x;


  CAMAC(NAF(ADC_MOD,0,9),&data,&q,&x);
  CAMAC(NAF(NELR,ELR_A,9),&data,&q,&x);

}


/*** user end process ***/
void UserEnd(){
  int data,q,x;

  CAMAC(NAF(NELR,ELR_A,25),&data,&q,&x);

}


/*** user terminate process ***/
void UserTerm(){

}


/*** system terminate process ***/
void SysTerm(){

  CCLOSE();    /* close CAMAC */

}

