/* ccpdrv.h */
/* CAMAC device driver for Hoshin CCP-PCI/CCP-ISA on Linux 2.[24].x */
/* Created					(M. Suehiro)	27 Aug 2002 */
/* Add Linux 2.[24].x support			(M. Suehiro)	27 Aug 2002 */
/* Add structure for inter-module communication	(M. Suehiro)	 3 Sep 2002 */

/* ORIGINAL */
/* camdrv.h */
/* CAMAC device driver for CC/7700-PCI on Linux 2.2.x */
/* Edited by Sanshiro E. on 11 April 1999. */
/* Last updated by Sanshiro E. on 14 April 1999. */


#ifndef __CCPDRV_H__
#define __CCPDRV_H__

#include <linux/ioctl.h>


#define CCPDRV_IOC_MAGIC 0xCD

#define CCPDRV_IOC_INITIALIZE         _IO(CCPDRV_IOC_MAGIC, 1)
#define CCPDRV_IOC_CLEAR              _IO(CCPDRV_IOC_MAGIC, 2)
#define CCPDRV_IOC_INHIBIT            _IO(CCPDRV_IOC_MAGIC, 3)
#define CCPDRV_IOC_RELEASE_INHIBIT    _IO(CCPDRV_IOC_MAGIC, 4)
#define CCPDRV_IOC_ENABLE_INTERRUPT   _IO(CCPDRV_IOC_MAGIC, 5)
#define CCPDRV_IOC_DISABLE_INTERRUPT  _IO(CCPDRV_IOC_MAGIC, 6)
#define CCPDRV_IOC_CAMAC_ACTION       _IOWR(CCPDRV_IOC_MAGIC, 7, 8)
#define CCPDRV_IOC_READ_LAM           _IOR(CCPDRV_IOC_MAGIC, 8, 8)
#define CCPDRV_IOC_WAIT_LAM           _IOWR(CCPDRV_IOC_MAGIC, 9, 8)


/* for communication between modules */
struct ccpdrv_lowlevel_struct {
    char name[16];
    int loaded;
    void (*open) ();
    void (*release) ();
    void (*write) ( int address, int data );
    int (*read) ( int address );
};

extern struct ccpdrv_lowlevel_struct *ccpdrv_lowlevel;


/* for kernel API compatibility between 2.2 and 2.4 */
#ifndef module_init
#  define module_init(x)	int init_module(void) { return x(); }
#  define module_exit(x)	void cleanup_module(void) { x(); }
#endif

#endif
