
import sys,os
from unix_base import *

class SystemEnviros:
	'Maintains system-wide environment variables pointing to Pacman installations.'
	def __init__(self):
		if os.path.exists('/etc/profile.d'):
			if os.path.exists('/etc/profile.d/pacman_enviros.csh') and \
			   os.path.exists('/etc/profile.d/pacman_enviros.sh'):
				self.csh = os.popen('cat /etc/profile.d/pacman_enviros.csh').readlines()
				self.sh  = os.popen('cat /etc/profile.d/pacman_enviros.sh').readlines()
			else:
				self.csh = ['#\n','#  Environment Variables Managed by Pacman; please do not edit this file. \n','#\n']
				self.sh  = ['#\n','#  Environment Variables Managed by Pacman; please do not edit this file. \n','#\n']
		else:
			print "No [/etc/profile.d] directory found."
			print "Can't set system-wide environement variables."
			sys.exit()
			
		if os.path.exists('systemenviros'):
			self.enviros = os.popen('cat systemenviros').readlines()
		else:
			self.enviros = []
				
	def insert(self,enviro):
		self.remove(enviro)
		self.csh.append('setenv '+enviro+' "'+os.getcwd()+'"\n')
		self.sh.append(enviro+'="'+os.getcwd()+'"; export '+enviro+'\n')
		self.enviros.append(enviro+'\n')
		os.environ[enviro] = os.getcwd()
	
	def remove(self,enviro):
		while (self.csh.count('setenv '+enviro+' "'+os.getcwd()+'"\n')>0):
			self.csh.remove('setenv '+enviro+' "'+os.getcwd()+'"\n')
		while (self.sh.count (enviro+'="'+os.getcwd()+'"; export '+enviro+'\n')>0):
			self.sh.remove(enviro+'="'+os.getcwd()+'"; export '+enviro+'\n')
		while (self.enviros.count(enviro+'\n')>0):
			self.enviros.remove(enviro+'\n')
	
	def place(self):
		os.system('rm -f pacman_enviros.csh')
		os.system('rm -f pacman_enviros.sh')
		os.system('rm -f systemenviros')
		csh_f = open('pacman_enviros.csh','w')
		sh_f  = open('pacman_enviros.sh','w')
		en_f  = open('systemenviros','w')
		
		for line_csh in self.csh:
			csh_f.write(line_csh)
		for line_sh  in self.sh:
			sh_f.write(line_sh)
		for line_en in self.enviros:
			en_f.write(line_en)
		csh_f.close()
		sh_f.close()
		en_f.close()
		os.system('chmod a+r systemenviros')
		
		if os.access('/etc/profile.d',os.W_OK):
			ask_to_execute('cp pacman_enviros.csh /etc/profile.d')
			ask_to_execute('cp pacman_enviros.sh  /etc/profile.d')
			ask_to_execute('chmod +x /etc/profile.d/pacman_enviros.csh')
			ask_to_execute('chmod +x /etc/profile.d/pacman_enviros.sh')
			os.system('rm -f pacman_enviros.csh')
			os.system('rm -f pacman_enviros.sh')
		else:
			print "You don't have write access to [/etc/profile.d]."
			sys.exit()
