      COMPLEX*16 FUNCTION CFACQ_HDEC(ICASE,AMH,AMQ)
C--CORRECTION FACTOR FOR SCALAR (ICASE=0) AND PSEUDOSCALAR (ICASE=1) HIGGS
      IMPLICIT DOUBLE PRECISION (A-B,D-H,O-Z), COMPLEX*16 (C)
      PI = 4*DATAN(1.D0)
      RHO = AMH**2/AMQ**2
      CKOFQ = CKOFQ_HDEC(ICASE,RHO)
      CFACQ_HDEC = 1.D0 + CKOFQ*ALPHAS_HDEC(AMH,3)/PI
      RETURN
      END
 
      COMPLEX*16 FUNCTION CKOFQ_HDEC(ICASE,RHO)
C--COMPLEX COEFFICIENT OF VIRTUAL CORRECTIONS
C--RHO = (MH/MQ)**2
C     PARAMETER(NN=999,N=461,NCUT1=46,NCUT2=54,NCUT3=341)
      PARAMETER(NN=999,N=461,NCUT1=46,NCUT2=54,NCUT3=251)
C     PARAMETER(NN=999,N=461,NCUT1=46,NCUT2=54,NCUT3=461)
      IMPLICIT DOUBLE PRECISION (A-B,D-H,O-Z), COMPLEX*16 (C)
      DIMENSION XC(NN),YCR(NN),YCI(NN)
      COMMON/RESINTQ_HDEC/XX(NN),YHR(NN),YHI(NN),YAR(NN),YAI(NN)
      PI=4.D0*DATAN(1.D0)
      RHO2=XX(NCUT3)
      REPS=1.D-15
C--CALCULATE COMPLEX COEFFICIENT BY INTERPOLATION
      IF(ICASE.EQ.1)THEN
C--PSEUDOSCALAR HIGGS
       IF(RHO.LE.RHO2)THEN
        CKOFQ_HDEC=DCMPLX(FINT1_HDEC(RHO,XX,YAR,N),
     .                    FINT1_HDEC(RHO,XX,YAI,N))
       ELSE
        FSU = 21.D0
        CRHO=RHO2/DCMPLX(1.D0,-REPS)
        CDLR=CDLOG(-CRHO)
        CLIM=-1.D0/18.D0*CDLR**2-2.D0/3.D0*CDLR+2.D0*DLOG(RHO2/4.D0)
     .       + FSU/DREAL(CDLR)
        CONST=DCMPLX(YAR(NCUT3),YAI(NCUT3))-CLIM
        CRHO=RHO/DCMPLX(1.D0,-REPS)
        CDLR=CDLOG(-CRHO)
        CLIM=-1.D0/18.D0*CDLR**2-2.D0/3.D0*CDLR+2.D0*DLOG(RHO/4.D0)
     .       + FSU/DREAL(CDLR)
        CKOFQ_HDEC=CLIM+CONST
       ENDIF
      ELSE
C--SCALAR HIGGS
       IF(RHO.LE.RHO2)THEN
        CKOFQ_HDEC=DCMPLX(FINT1_HDEC(RHO,XX,YHR,N),
     .                    FINT1_HDEC(RHO,XX,YHI,N))
       ELSE
        FSU = 22.D0
        CRHO=RHO2/DCMPLX(1.D0,-REPS)
        CDLR=CDLOG(-CRHO)
        CLIM=-1.D0/18.D0*CDLR**2-2.D0/3.D0*CDLR+2.D0*DLOG(RHO2/4.D0)
     .       + FSU/DREAL(CDLR)
        CONST=DCMPLX(YHR(NCUT3),YHI(NCUT3))-CLIM
        CRHO=RHO/DCMPLX(1.D0,-REPS)
        CDLR=CDLOG(-CRHO)
        CLIM=-1.D0/18.D0*CDLR**2-2.D0/3.D0*CDLR+2.D0*DLOG(RHO/4.D0)
     .       + FSU/DREAL(CDLR)
        CKOFQ_HDEC=CLIM+CONST
       ENDIF
      ENDIF
      RETURN
      END
 
      COMPLEX*16 FUNCTION CFACSQ_HDEC(AMH,AMSQ)
C--CORRECTION FACTOR FOR SCALAR HIGGS
      IMPLICIT DOUBLE PRECISION (A-B,D-H,O-Z), COMPLEX*16 (C)
      PI = 4*DATAN(1.D0)
      RHO = AMH**2/AMSQ**2
      CFACSQ_HDEC = 1.D0 + CKOFSQ_HDEC(RHO)*ALPHAS_HDEC(AMH,3)/PI
      RETURN
      END
 
      COMPLEX*16 FUNCTION CKOFSQ_HDEC(RHO)
C--COMPLEX COEFFICIENT OF VIRTUAL CORRECTIONS TO SQUARK LOOPS
C--RHO = (MH/MQ)**2
C     PARAMETER(NN=999,N=461,NCUT1=46,NCUT2=54,NCUT3=341)
      PARAMETER(NN=999,N=461,NCUT1=46,NCUT2=54,NCUT3=251)
C     PARAMETER(NN=999,N=461,NCUT1=46,NCUT2=54,NCUT3=461)
      IMPLICIT DOUBLE PRECISION (A-B,D-H,O-Z), COMPLEX*16 (C)
      DIMENSION XC(NN),YCR(NN),YCI(NN)
      COMMON/RESINTSQ_HDEC/XX(NN),YHR(NN),YHI(NN)
      PI=4.D0*DATAN(1.D0)
      RHO2=XX(NCUT3)
      REPS=1.D-15
C--CALCULATE COMPLEX COEFFICIENT BY INTERPOLATION
C--SCALAR HIGGS
      IF(RHO.LE.RHO2)THEN
       CKOFSQ_HDEC=DCMPLX(FINT1_HDEC(RHO,XX,YHR,N),
     .                    FINT1_HDEC(RHO,XX,YHI,N))
      ELSE
       FSU = 2.D0
       CRHO=RHO2/DCMPLX(1.D0,-REPS)
       CDLR=CDLOG(-CRHO)
       CLIM=DCMPLX(1.D0,PI) + FSU/DREAL(CDLR)
       CONST=DCMPLX(YHR(NCUT3),YHI(NCUT3))-CLIM
       CRHO=RHO/DCMPLX(1.D0,-REPS)
       CDLR=CDLOG(-CRHO)
       CLIM=DCMPLX(1.D0,PI) + FSU/DREAL(CDLR)
       CKOFSQ_HDEC=CLIM+CONST
      ENDIF
      RETURN
      END
 
      DOUBLE PRECISION FUNCTION FINT1_HDEC(X,XP,YP,NP)
C--ONE-DIMENSIONAL QUADRATIC INTERPOLATION
C--X  = WANTED POINT
C--XP = ARRAY OF DISCRETE X-VALUES
C--YP = ARRAY OF DISCRETE FUNCTION-VALUES
C--NP = NUMBER OF DISCTRETE POINTS
      PARAMETER(N0=999,N1=3)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION XP(N0),YP(N0),X0(N1),Y0(N1),XX(N1),YY(N1)
C     KORD = 2
      KORD = 1
      DO 1 I=1,NP
       IF(X.GE.XP(I)) NX=I
1     CONTINUE
      IF(NX.EQ.NP)NX=NP-2
C     IF(NX.EQ.1.AND.KORD.EQ.2)NX=2
      IF(NX.EQ.1)NX=2
      DO 2 I=1,3
        X0(I)=XP(NX+I-2)
2     CONTINUE
      DO 3 I=1,3
        Y0(I)=YP(NX+I-2)
3     CONTINUE
      FINT1_HDEC=FINT0_HDEC(X,X0,Y0)
      RETURN
      END

      DOUBLE PRECISION FUNCTION FINT0_HDEC(X,XX,YY)
C--ONE-DIMENSIONAL QUADRATIC INTERPOLATION
C--X  = WANTED POINT
C--XX = ARRAY OF 3 DISCRETE X-VALUES AROUND X
C--YY = ARRAY OF 3 DISCRETE FUNCTION-VALUES AROUND X
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION XX(3),YY(3)
C     KORD = 2
      KORD = 1
      X0=XX(1)
      X1=XX(2)
      X2=XX(3)
      Y0=YY(1)
      Y1=YY(2)
      Y2=YY(3)
      IF(X.LT.X1)THEN
       A0=(X-X1)/(X0-X1)
       A1=(X-X0)/(X1-X0)
       GINT=A0*Y0+A1*Y1
      ELSE
       A1=(X-X2)/(X1-X2)
       A2=(X-X1)/(X2-X1)
       GINT=A1*Y1+A2*Y2
      ENDIF
      IF(KORD.EQ.2) THEN
       A0=(X-X1)*(X-X2)/(X0-X1)/(X0-X2)
       A1=(X-X0)*(X-X2)/(X1-X0)/(X1-X2)
       A2=(X-X0)*(X-X1)/(X2-X0)/(X2-X1)
       GINT=A0*Y0+A1*Y1+A2*Y2
      ENDIF
      FINT0_HDEC=GINT
      RETURN
      END

      DOUBLE PRECISION FUNCTION RUNMS_HDEC(Q,AMSQ)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      B0(NF)=(33.D0-2.D0*NF)/12D0
      G0(NF) = 1D0/2D0
      TRAN(X)=1D0+7D0/3D0*ALPHAS_HDEC(X,3)/PI
      CSQ(X,NF)=(2D0*B0(NF)*X)**(G0(NF)/B0(NF))
      PI=4D0*DATAN(1D0)
      Q0 = AMSQ
      N0 = 5
C     RMSQ = AMSQ/TRAN(AMSQ)
      RMSQ = AMSQ
      RUNMS_HDEC = RMSQ*CSQ(ALPHAS_HDEC(Q,3)/PI,N0)/
     .                  CSQ(ALPHAS_HDEC(Q0,3)/PI,N0)
      RETURN
      END

      BLOCKDATA CVIRTQ_HDEC
C--DATA OF VIRTUAL CORRECTIONS TO QUARK LOOPS
      PARAMETER(NN=999)
      IMPLICIT DOUBLE PRECISION (A-B,D-H,O-Z), COMPLEX*16 (C)
      COMMON/RESINTQ_HDEC/XX(NN),YHR(NN),YHI(NN),YAR(NN),YAI(NN)

      DATA ( XX(I),I=  1, 40)/
     .    .000000D+00,    .100000D+00,    .200000D+00,    .300000D+00,
     .    .400000D+00,    .500000D+00,    .600000D+00,    .800000D+00,
     .    .900000D+00,    .100000D+01,    .110000D+01,    .120000D+01,
     .    .130000D+01,    .150000D+01,    .160000D+01,    .170000D+01,
     .    .180000D+01,    .190000D+01,    .200000D+01,    .210000D+01,
     .    .220000D+01,    .230000D+01,    .240000D+01,    .250000D+01,
     .    .260000D+01,    .270000D+01,    .280000D+01,    .300000D+01,
     .    .310000D+01,    .320000D+01,    .330000D+01,    .340000D+01,
     .    .350000D+01,    .360000D+01,    .370000D+01,    .380000D+01,
     .    .390000D+01,    .391000D+01,    .392000D+01,    .393000D+01/
 
      DATA ( XX(I),I= 41, 80)/
     .    .394000D+01,    .395000D+01,    .396000D+01,    .397000D+01,
     .    .398000D+01,    .399000D+01,    .399900D+01,    .399990D+01,
     .    .399999D+01,    .400001D+01,    .400010D+01,    .400100D+01,
     .    .401000D+01,    .402000D+01,    .403000D+01,    .404000D+01,
     .    .405000D+01,    .406000D+01,    .407000D+01,    .408000D+01,
     .    .409000D+01,    .410000D+01,    .420000D+01,    .430000D+01,
     .    .440000D+01,    .450000D+01,    .460000D+01,    .470000D+01,
     .    .480000D+01,    .490000D+01,    .500000D+01,    .510000D+01,
     .    .520000D+01,    .530000D+01,    .540000D+01,    .550000D+01,
     .    .560000D+01,    .570000D+01,    .580000D+01,    .590000D+01/
 
      DATA ( XX(I),I= 81,120)/
     .    .600000D+01,    .610000D+01,    .620000D+01,    .630000D+01,
     .    .640000D+01,    .650000D+01,    .660000D+01,    .670000D+01,
     .    .680000D+01,    .690000D+01,    .700000D+01,    .710000D+01,
     .    .720000D+01,    .730000D+01,    .740000D+01,    .750000D+01,
     .    .760000D+01,    .770000D+01,    .780000D+01,    .790000D+01,
     .    .800000D+01,    .810000D+01,    .820000D+01,    .830000D+01,
     .    .840000D+01,    .850000D+01,    .860000D+01,    .870000D+01,
     .    .880000D+01,    .890000D+01,    .900000D+01,    .910000D+01,
     .    .920000D+01,    .930000D+01,    .940000D+01,    .950000D+01,
     .    .960000D+01,    .970000D+01,    .980000D+01,    .990000D+01/
 
      DATA ( XX(I),I=121,160)/
     .    .100000D+02,    .105000D+02,    .110000D+02,    .115000D+02,
     .    .120000D+02,    .125000D+02,    .130000D+02,    .135000D+02,
     .    .140000D+02,    .145000D+02,    .150000D+02,    .155000D+02,
     .    .160000D+02,    .165000D+02,    .170000D+02,    .175000D+02,
     .    .180000D+02,    .185000D+02,    .190000D+02,    .195000D+02,
     .    .200000D+02,    .210000D+02,    .220000D+02,    .230000D+02,
     .    .240000D+02,    .250000D+02,    .260000D+02,    .270000D+02,
     .    .280000D+02,    .290000D+02,    .300000D+02,    .310000D+02,
     .    .320000D+02,    .330000D+02,    .340000D+02,    .350000D+02,
     .    .360000D+02,    .370000D+02,    .380000D+02,    .390000D+02/
 
      DATA ( XX(I),I=161,200)/
     .    .400000D+02,    .410000D+02,    .420000D+02,    .430000D+02,
     .    .440000D+02,    .450000D+02,    .460000D+02,    .470000D+02,
     .    .480000D+02,    .490000D+02,    .500000D+02,    .510000D+02,
     .    .520000D+02,    .530000D+02,    .540000D+02,    .550000D+02,
     .    .560000D+02,    .570000D+02,    .580000D+02,    .590000D+02,
     .    .600000D+02,    .610000D+02,    .620000D+02,    .630000D+02,
     .    .640000D+02,    .650000D+02,    .660000D+02,    .670000D+02,
     .    .680000D+02,    .690000D+02,    .700000D+02,    .710000D+02,
     .    .720000D+02,    .730000D+02,    .740000D+02,    .750000D+02,
     .    .760000D+02,    .770000D+02,    .780000D+02,    .790000D+02/
 
      DATA ( XX(I),I=201,240)/
     .    .800000D+02,    .810000D+02,    .820000D+02,    .830000D+02,
     .    .840000D+02,    .850000D+02,    .860000D+02,    .870000D+02,
     .    .880000D+02,    .890000D+02,    .900000D+02,    .910000D+02,
     .    .920000D+02,    .930000D+02,    .940000D+02,    .950000D+02,
     .    .960000D+02,    .970000D+02,    .980000D+02,    .990000D+02,
     .    .100000D+03,    .105000D+03,    .110000D+03,    .115000D+03,
     .    .120000D+03,    .125000D+03,    .130000D+03,    .135000D+03,
     .    .140000D+03,    .145000D+03,    .150000D+03,    .155000D+03,
     .    .160000D+03,    .165000D+03,    .170000D+03,    .175000D+03,
     .    .180000D+03,    .185000D+03,    .190000D+03,    .195000D+03/
 
      DATA ( XX(I),I=241,280)/
     .    .200000D+03,    .210000D+03,    .220000D+03,    .230000D+03,
     .    .240000D+03,    .250000D+03,    .260000D+03,    .270000D+03,
     .    .280000D+03,    .290000D+03,    .300000D+03,    .310000D+03,
     .    .320000D+03,    .330000D+03,    .340000D+03,    .350000D+03,
     .    .360000D+03,    .370000D+03,    .380000D+03,    .390000D+03,
     .    .400000D+03,    .410000D+03,    .420000D+03,    .430000D+03,
     .    .440000D+03,    .450000D+03,    .460000D+03,    .470000D+03,
     .    .480000D+03,    .490000D+03,    .500000D+03,    .550000D+03,
     .    .600000D+03,    .650000D+03,    .700000D+03,    .750000D+03,
     .    .800000D+03,    .850000D+03,    .900000D+03,    .950000D+03/
 
      DATA ( XX(I),I=281,320)/
     .    .100000D+04,    .105000D+04,    .110000D+04,    .115000D+04,
     .    .120000D+04,    .125000D+04,    .130000D+04,    .135000D+04,
     .    .140000D+04,    .145000D+04,    .150000D+04,    .155000D+04,
     .    .160000D+04,    .165000D+04,    .170000D+04,    .175000D+04,
     .    .180000D+04,    .185000D+04,    .190000D+04,    .195000D+04,
     .    .200000D+04,    .210000D+04,    .220000D+04,    .230000D+04,
     .    .240000D+04,    .250000D+04,    .260000D+04,    .270000D+04,
     .    .280000D+04,    .290000D+04,    .300000D+04,    .310000D+04,
     .    .320000D+04,    .330000D+04,    .340000D+04,    .350000D+04,
     .    .360000D+04,    .370000D+04,    .380000D+04,    .390000D+04/
 
      DATA ( XX(I),I=321,360)/
     .    .400000D+04,    .410000D+04,    .420000D+04,    .430000D+04,
     .    .440000D+04,    .450000D+04,    .460000D+04,    .470000D+04,
     .    .480000D+04,    .490000D+04,    .500000D+04,    .550000D+04,
     .    .600000D+04,    .650000D+04,    .700000D+04,    .750000D+04,
     .    .800000D+04,    .850000D+04,    .900000D+04,    .950000D+04,
     .    .100000D+05,    .105000D+05,    .110000D+05,    .115000D+05,
     .    .120000D+05,    .125000D+05,    .130000D+05,    .135000D+05,
     .    .140000D+05,    .145000D+05,    .150000D+05,    .155000D+05,
     .    .160000D+05,    .165000D+05,    .170000D+05,    .175000D+05,
     .    .180000D+05,    .185000D+05,    .190000D+05,    .195000D+05/
 
      DATA ( XX(I),I=361,400)/
     .    .200000D+05,    .210000D+05,    .220000D+05,    .230000D+05,
     .    .240000D+05,    .250000D+05,    .260000D+05,    .270000D+05,
     .    .280000D+05,    .290000D+05,    .300000D+05,    .310000D+05,
     .    .320000D+05,    .330000D+05,    .340000D+05,    .350000D+05,
     .    .360000D+05,    .370000D+05,    .380000D+05,    .390000D+05,
     .    .400000D+05,    .410000D+05,    .420000D+05,    .430000D+05,
     .    .440000D+05,    .450000D+05,    .460000D+05,    .470000D+05,
     .    .480000D+05,    .490000D+05,    .500000D+05,    .550000D+05,
     .    .600000D+05,    .650000D+05,    .700000D+05,    .750000D+05,
     .    .800000D+05,    .850000D+05,    .900000D+05,    .950000D+05/
 
      DATA ( XX(I),I=401,440)/
     .    .100000D+06,    .105000D+06,    .110000D+06,    .115000D+06,
     .    .120000D+06,    .125000D+06,    .130000D+06,    .135000D+06,
     .    .140000D+06,    .145000D+06,    .150000D+06,    .155000D+06,
     .    .160000D+06,    .165000D+06,    .170000D+06,    .175000D+06,
     .    .180000D+06,    .185000D+06,    .190000D+06,    .195000D+06,
     .    .200000D+06,    .210000D+06,    .220000D+06,    .230000D+06,
     .    .240000D+06,    .250000D+06,    .260000D+06,    .270000D+06,
     .    .280000D+06,    .290000D+06,    .300000D+06,    .310000D+06,
     .    .320000D+06,    .330000D+06,    .340000D+06,    .350000D+06,
     .    .360000D+06,    .370000D+06,    .380000D+06,    .390000D+06/
 
      DATA ( XX(I),I=441,461)/
     .    .400000D+06,    .410000D+06,    .420000D+06,    .430000D+06,
     .    .440000D+06,    .450000D+06,    .460000D+06,    .470000D+06,
     .    .480000D+06,    .490000D+06,    .500000D+06,    .550000D+06,
     .    .600000D+06,    .650000D+06,    .700000D+06,    .750000D+06,
     .    .800000D+06,    .850000D+06,    .900000D+06,    .950000D+06,
     .    .100000D+07/
 
C--SCALAR HIGGS
 
      DATA (YHR(I),I=  1, 40)/
     .   -.100000D+01,   -.927441D+00,   -.869924D+00,   -.817177D+00,
     .   -.767312D+00,   -.719200D+00,   -.672446D+00,   -.581397D+00,
     .   -.536618D+00,   -.492090D+00,   -.447672D+00,   -.403219D+00,
     .   -.358621D+00,   -.268547D+00,   -.222867D+00,   -.176611D+00,
     .   -.129675D+00,   -.819423D-01,   -.332945D-01,    .163991D-01,
     .    .672815D-01,    .119511D+00,    .173264D+00,    .228746D+00,
     .    .286188D+00,    .345864D+00,    .408096D+00,    .541869D+00,
     .    .614478D+00,    .691855D+00,    .774994D+00,    .865237D+00,
     .    .964487D+00,    .107560D+01,    .120321D+01,    .135588D+01,
     .    .155363D+01,    .157767D+01,    .160287D+01,    .162943D+01/
 
      DATA (YHR(I),I= 41, 80)/
     .    .165759D+01,    .168767D+01,    .172015D+01,    .175574D+01,
     .    .179570D+01,    .184277D+01,    .189992D+01,    .190856D+01,
     .    .190816D+01,    .191040D+01,    .191528D+01,    .192098D+01,
     .    .197460D+01,    .201580D+01,    .204905D+01,    .207574D+01,
     .    .209851D+01,    .211773D+01,    .213446D+01,    .214853D+01,
     .    .216057D+01,    .216744D+01,    .221729D+01,    .220296D+01,
     .    .216081D+01,    .210492D+01,    .204199D+01,    .197719D+01,
     .    .191032D+01,    .184470D+01,    .178029D+01,    .171754D+01,
     .    .165532D+01,    .159850D+01,    .154193D+01,    .148776D+01,
     .    .143516D+01,    .138350D+01,    .133562D+01,    .128976D+01/
 
      DATA (YHR(I),I= 81,120)/
     .    .124391D+01,    .120180D+01,    .114356D+01,    .111983D+01,
     .    .107929D+01,    .104118D+01,    .100798D+01,    .972828D+00,
     .    .939543D+00,    .907679D+00,    .875162D+00,    .845178D+00,
     .    .815781D+00,    .786939D+00,    .758925D+00,    .732151D+00,
     .    .708721D+00,    .680419D+00,    .656115D+00,    .627813D+00,
     .    .607953D+00,    .585186D+00,    .564079D+00,    .543358D+00,
     .    .519945D+00,    .501228D+00,    .482208D+00,    .462914D+00,
     .    .443843D+00,    .423406D+00,    .405523D+00,    .390305D+00,
     .    .372823D+00,    .356942D+00,    .341011D+00,    .325279D+00,
     .    .309142D+00,    .291987D+00,    .278605D+00,    .264273D+00/
 
      DATA (YHR(I),I=121,160)/
     .    .245908D+00,    .185240D+00,    .125335D+00,    .704656D-01,
     .    .200125D-01,   -.240342D-01,   -.651205D-01,   -.109398D+00,
     .   -.139416D+00,   -.172698D+00,   -.203135D+00,   -.236326D+00,
     .   -.258392D+00,   -.283294D+00,   -.308585D+00,   -.328643D+00,
     .   -.349320D+00,   -.368802D+00,   -.387273D+00,   -.407786D+00,
     .   -.421121D+00,   -.451707D+00,   -.480408D+00,   -.504263D+00,
     .   -.526996D+00,   -.548619D+00,   -.567090D+00,   -.584278D+00,
     .   -.601708D+00,   -.618328D+00,   -.629492D+00,   -.642368D+00,
     .   -.656192D+00,   -.658050D+00,   -.676002D+00,   -.685964D+00,
     .   -.694894D+00,   -.703118D+00,   -.711672D+00,   -.719376D+00/
 
      DATA (YHR(I),I=161,200)/
     .   -.726336D+00,   -.733111D+00,   -.738446D+00,   -.745617D+00,
     .   -.750834D+00,   -.756526D+00,   -.761135D+00,   -.766284D+00,
     .   -.770796D+00,   -.775271D+00,   -.779027D+00,   -.784572D+00,
     .   -.781892D+00,   -.790649D+00,   -.793657D+00,   -.797130D+00,
     .   -.794663D+00,   -.802681D+00,   -.805868D+00,   -.808586D+00,
     .   -.810295D+00,   -.813375D+00,   -.815067D+00,   -.817611D+00,
     .   -.820263D+00,   -.846351D+00,   -.823568D+00,   -.825093D+00,
     .   -.827373D+00,   -.828609D+00,   -.830533D+00,   -.832803D+00,
     .   -.833843D+00,   -.834707D+00,   -.835837D+00,   -.837438D+00,
     .   -.838412D+00,   -.840201D+00,   -.840807D+00,   -.841834D+00/
 
      DATA (YHR(I),I=201,240)/
     .   -.842494D+00,   -.844236D+00,   -.844902D+00,   -.846423D+00,
     .   -.846218D+00,   -.848076D+00,   -.847243D+00,   -.848934D+00,
     .   -.849710D+00,   -.850620D+00,   -.848762D+00,   -.850072D+00,
     .   -.851960D+00,   -.852263D+00,   -.851032D+00,   -.853975D+00,
     .   -.852750D+00,   -.854733D+00,   -.854514D+00,   -.855586D+00,
     .   -.853035D+00,   -.857534D+00,   -.858538D+00,   -.857642D+00,
     .   -.859737D+00,   -.857643D+00,   -.859246D+00,   -.859728D+00,
     .   -.859301D+00,   -.858410D+00,   -.850751D+00,   -.856733D+00,
     .   -.852269D+00,   -.854401D+00,   -.847711D+00,   -.852584D+00,
     .   -.850211D+00,   -.849486D+00,   -.848842D+00,   -.846225D+00/
 
      DATA (YHR(I),I=241,280)/
     .   -.845614D+00,   -.843069D+00,   -.840826D+00,   -.837130D+00,
     .   -.832595D+00,   -.831445D+00,   -.827453D+00,   -.826158D+00,
     .   -.818321D+00,   -.819760D+00,   -.817700D+00,   -.808913D+00,
     .   -.810473D+00,   -.808702D+00,   -.797813D+00,   -.804471D+00,
     .   -.800639D+00,   -.797065D+00,   -.795652D+00,   -.784755D+00,
     .   -.784269D+00,   -.758252D+00,   -.783134D+00,   -.766990D+00,
     .   -.778123D+00,   -.761039D+00,   -.775339D+00,   -.804565D+00,
     .   -.766608D+00,   -.849462D+00,   -.766164D+00,   -.754759D+00,
     .   -.746806D+00,   -.713458D+00,   -.732591D+00,   -.720410D+00,
     .   -.643175D+00,   -.698920D+00,   -.688168D+00,   -.674130D+00/
 
      DATA (YHR(I),I=281,320)/
     .   -.678493D+00,   -.714939D+00,   -.676100D+00,   -.668246D+00,
     .   -.662452D+00,   -.657413D+00,   -.645239D+00,   -.634979D+00,
     .   -.626567D+00,   -.638122D+00,   -.619530D+00,   -.642324D+00,
     .   -.562415D+00,   -.612792D+00,   -.619285D+00,   -.613920D+00,
     .   -.586612D+00,   -.571036D+00,   -.420769D+00,   -.617035D+00,
     .   -.602944D+00,   -.582262D+00,   -.599127D+00,   -.518984D+00,
     .   -.595767D+00,   -.562811D+00,   -.521940D+00,   -.564636D+00,
     .   -.574503D+00,   -.574409D+00,   -.567140D+00,   -.565250D+00,
     .   -.542017D+00,   -.542258D+00,   -.605122D+00,   -.550489D+00,
     .   -.552080D+00,   -.495920D+00,   -.552101D+00,   -.529456D+00/
 
      DATA (YHR(I),I=321,360)/
     .   -.508396D+00,   -.545684D+00,   -.543586D+00,   -.541676D+00,
     .   -.554687D+00,   -.566808D+00,   -.536475D+00,   -.469854D+00,
     .   -.461855D+00,   -.470391D+00,   -.530002D+00,   -.493075D+00,
     .   -.517297D+00,   -.551096D+00,   -.507831D+00,   -.490137D+00,
     .   -.483976D+00,   -.680103D+00,   -.495081D+00,   -.492797D+00,
     .   -.490778D+00,   -.489008D+00,   -.487440D+00,   -.486067D+00,
     .   -.484862D+00,   -.483812D+00,   -.482894D+00,   -.482104D+00,
     .   -.481422D+00,   -.480848D+00,   -.480367D+00,   -.479969D+00,
     .   -.479647D+00,   -.479399D+00,   -.479217D+00,   -.479084D+00,
     .   -.478968D+00,   -.479021D+00,   -.479051D+00,   -.479130D+00/
 
      DATA (YHR(I),I=361,400)/
     .   -.479257D+00,   -.479605D+00,   -.480093D+00,   -.480700D+00,
     .   -.481403D+00,   -.482196D+00,   -.483064D+00,   -.484004D+00,
     .   -.485012D+00,   -.486065D+00,   -.487162D+00,   -.488308D+00,
     .   -.489496D+00,   -.490704D+00,   -.491951D+00,   -.493209D+00,
     .   -.494505D+00,   -.495763D+00,   -.497137D+00,   -.498488D+00,
     .   -.499848D+00,   -.501226D+00,   -.502609D+00,   -.503998D+00,
     .   -.505396D+00,   -.506809D+00,   -.508217D+00,   -.509631D+00,
     .   -.511056D+00,   -.512476D+00,   -.513903D+00,   -.521065D+00,
     .   -.528187D+00,   -.535257D+00,   -.540755D+00,   -.549182D+00,
     .   -.555981D+00,   -.560893D+00,   -.565133D+00,   -.573151D+00/
 
      DATA (YHR(I),I=401,440)/
     .   -.541651D+00,   -.585103D+00,   -.591189D+00,   -.597202D+00,
     .   -.603083D+00,   -.608874D+00,   -.614535D+00,   -.620134D+00,
     .   -.625623D+00,   -.631032D+00,   -.636371D+00,   -.641617D+00,
     .   -.646765D+00,   -.651828D+00,   -.656796D+00,   -.661762D+00,
     .   -.666796D+00,   -.671626D+00,   -.676202D+00,   -.680997D+00,
     .   -.685480D+00,   -.694512D+00,   -.702963D+00,   -.711486D+00,
     .   -.720127D+00,   -.728442D+00,   -.736328D+00,   -.743756D+00,
     .   -.751683D+00,   -.758805D+00,   -.766253D+00,   -.773209D+00,
     .   -.780313D+00,   -.787645D+00,   -.794058D+00,   -.801012D+00,
     .   -.807048D+00,   -.813671D+00,   -.819998D+00,   -.825862D+00/
 
      DATA (YHR(I),I=441,461)/
     .   -.831777D+00,   -.838235D+00,   -.844423D+00,   -.849783D+00,
     .   -.855583D+00,   -.861151D+00,   -.866525D+00,   -.872437D+00,
     .   -.877258D+00,   -.883273D+00,   -.888348D+00,   -.913280D+00,
     .   -.937035D+00,   -.959378D+00,   -.980326D+00,   -.100083D+01,
     .   -.101975D+01,   -.103825D+01,   -.105586D+01,   -.107298D+01,
     .   -.107033D+01/
 
      DATA (YHI(I),I=  1, 40)/
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00/
 
      DATA (YHI(I),I= 41, 80)/
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .139705D-01,    .166124D-03,    .494042D-02,
     .    .499256D-01,    .968562D-01,    .141384D+00,    .187771D+00,
     .    .229458D+00,    .267845D+00,    .308209D+00,    .345321D+00,
     .    .395539D+00,    .367417D+00,    .740121D+00,    .997240D+00,
     .    .120937D+01,    .138638D+01,    .153679D+01,    .166743D+01,
     .    .178125D+01,    .187930D+01,    .196839D+01,    .204542D+01,
     .    .211221D+01,    .217781D+01,    .223576D+01,    .228709D+01,
     .    .233426D+01,    .237390D+01,    .241606D+01,    .245369D+01/
 
      DATA (YHI(I),I= 81,120)/
     .    .248707D+01,    .251809D+01,    .254265D+01,    .257350D+01,
     .    .259549D+01,    .261663D+01,    .264428D+01,    .266572D+01,
     .    .268379D+01,    .270348D+01,    .271877D+01,    .273457D+01,
     .    .274967D+01,    .276430D+01,    .277741D+01,    .279001D+01,
     .    .280226D+01,    .281395D+01,    .282447D+01,    .283028D+01,
     .    .284466D+01,    .285612D+01,    .286351D+01,    .287193D+01,
     .    .287898D+01,    .288857D+01,    .289521D+01,    .290258D+01,
     .    .290929D+01,    .291392D+01,    .292531D+01,    .292875D+01,
     .    .293383D+01,    .294051D+01,    .294524D+01,    .294958D+01,
     .    .295591D+01,    .295944D+01,    .296493D+01,    .297006D+01/
 
      DATA (YHI(I),I=121,160)/
     .    .297878D+01,    .299168D+01,    .300815D+01,    .302172D+01,
     .    .303577D+01,    .304427D+01,    .305397D+01,    .306030D+01,
     .    .306860D+01,    .307536D+01,    .308121D+01,    .308706D+01,
     .    .309234D+01,    .309576D+01,    .310094D+01,    .310373D+01,
     .    .310812D+01,    .311096D+01,    .311436D+01,    .312141D+01,
     .    .311997D+01,    .312525D+01,    .313017D+01,    .313464D+01,
     .    .313871D+01,    .314274D+01,    .314791D+01,    .315082D+01,
     .    .315709D+01,    .315845D+01,    .316089D+01,    .316346D+01,
     .    .316732D+01,    .311145D+01,    .317313D+01,    .317616D+01,
     .    .317913D+01,    .318204D+01,    .318486D+01,    .318773D+01/
 
      DATA (YHI(I),I=161,200)/
     .    .319061D+01,    .319321D+01,    .320187D+01,    .319879D+01,
     .    .320179D+01,    .320398D+01,    .320656D+01,    .320914D+01,
     .    .321203D+01,    .321436D+01,    .321715D+01,    .322008D+01,
     .    .322221D+01,    .322436D+01,    .322711D+01,    .322946D+01,
     .    .324445D+01,    .323813D+01,    .323863D+01,    .323903D+01,
     .    .324134D+01,    .324374D+01,    .324820D+01,    .324992D+01,
     .    .325445D+01,    .319143D+01,    .325610D+01,    .325723D+01,
     .    .325939D+01,    .327355D+01,    .326397D+01,    .326580D+01,
     .    .326823D+01,    .327135D+01,    .327464D+01,    .327459D+01,
     .    .327719D+01,    .327898D+01,    .328095D+01,    .328350D+01/
 
      DATA (YHI(I),I=201,240)/
     .    .328634D+01,    .328714D+01,    .328919D+01,    .329193D+01,
     .    .329356D+01,    .329638D+01,    .329870D+01,    .329971D+01,
     .    .330127D+01,    .330310D+01,    .331401D+01,    .330694D+01,
     .    .330977D+01,    .331053D+01,    .331575D+01,    .331482D+01,
     .    .331577D+01,    .331830D+01,    .331995D+01,    .332218D+01,
     .    .332331D+01,    .333301D+01,    .334191D+01,    .335621D+01,
     .    .335669D+01,    .337441D+01,    .337793D+01,    .338310D+01,
     .    .339020D+01,    .339835D+01,    .341320D+01,    .341224D+01,
     .    .342706D+01,    .342728D+01,    .345066D+01,    .343888D+01,
     .    .344764D+01,    .345347D+01,    .345737D+01,    .346394D+01/
 
      DATA (YHI(I),I=241,280)/
     .    .346952D+01,    .348172D+01,    .349208D+01,    .350470D+01,
     .    .351742D+01,    .352480D+01,    .353704D+01,    .354313D+01,
     .    .354865D+01,    .355820D+01,    .356917D+01,    .358924D+01,
     .    .358673D+01,    .359536D+01,    .360856D+01,    .361016D+01,
     .    .361710D+01,    .362771D+01,    .363114D+01,    .364280D+01,
     .    .365361D+01,    .366774D+01,    .366132D+01,    .366077D+01,
     .    .367421D+01,    .368609D+01,    .368474D+01,    .364163D+01,
     .    .370204D+01,    .346697D+01,    .371006D+01,    .373535D+01,
     .    .376127D+01,    .379671D+01,    .381056D+01,    .382743D+01,
     .    .392101D+01,    .386736D+01,    .388928D+01,    .391311D+01/
 
      DATA (YHI(I),I=281,320)/
     .    .391851D+01,    .388620D+01,    .394091D+01,    .395906D+01,
     .    .396719D+01,    .398520D+01,    .401060D+01,    .400928D+01,
     .    .400658D+01,    .403163D+01,    .404640D+01,    .405804D+01,
     .    .405067D+01,    .407206D+01,    .408263D+01,    .409656D+01,
     .    .408983D+01,    .408728D+01,    .428879D+01,    .413343D+01,
     .    .413785D+01,    .416187D+01,    .417099D+01,    .420643D+01,
     .    .419376D+01,    .422760D+01,    .417148D+01,    .424094D+01,
     .    .423609D+01,    .425860D+01,    .425851D+01,    .426455D+01,
     .    .429598D+01,    .431438D+01,    .424688D+01,    .432604D+01,
     .    .432545D+01,    .425836D+01,    .435847D+01,    .438026D+01/
 
      DATA (YHI(I),I=321,360)/
     .    .437104D+01,    .438465D+01,    .439305D+01,    .440118D+01,
     .    .437181D+01,    .437103D+01,    .442437D+01,    .447627D+01,
     .    .435433D+01,    .444932D+01,    .445342D+01,    .449478D+01,
     .    .451698D+01,    .455927D+01,    .457103D+01,    .462246D+01,
     .    .465664D+01,    .447002D+01,    .465970D+01,    .467886D+01,
     .    .469706D+01,    .471440D+01,    .473094D+01,    .474677D+01,
     .    .476194D+01,    .477650D+01,    .479051D+01,    .480399D+01,
     .    .481700D+01,    .482956D+01,    .484170D+01,    .485345D+01,
     .    .486484D+01,    .487588D+01,    .488659D+01,    .489699D+01,
     .    .490704D+01,    .491698D+01,    .492657D+01,    .493592D+01/
 
      DATA (YHI(I),I=361,400)/
     .    .494504D+01,    .496261D+01,    .497939D+01,    .499543D+01,
     .    .501078D+01,    .502553D+01,    .503971D+01,    .505335D+01,
     .    .506651D+01,    .507922D+01,    .509149D+01,    .510337D+01,
     .    .511487D+01,    .512603D+01,    .513686D+01,    .514737D+01,
     .    .515759D+01,    .516759D+01,    .517723D+01,    .518667D+01,
     .    .519586D+01,    .520484D+01,    .521359D+01,    .522216D+01,
     .    .523052D+01,    .523868D+01,    .524668D+01,    .525451D+01,
     .    .526218D+01,    .526969D+01,    .527704D+01,    .531177D+01,
     .    .534349D+01,    .537269D+01,    .540070D+01,    .542495D+01,
     .    .544854D+01,    .547180D+01,    .548913D+01,    .550768D+01/
 
      DATA (YHI(I),I=401,440)/
     .    .555476D+01,    .555147D+01,    .556854D+01,    .558487D+01,
     .    .560050D+01,    .561547D+01,    .562990D+01,    .564376D+01,
     .    .565714D+01,    .567002D+01,    .568250D+01,    .569455D+01,
     .    .570624D+01,    .571757D+01,    .572856D+01,    .573924D+01,
     .    .574948D+01,    .575956D+01,    .576943D+01,    .577892D+01,
     .    .578833D+01,    .580625D+01,    .582358D+01,    .583992D+01,
     .    .585547D+01,    .587040D+01,    .588485D+01,    .589896D+01,
     .    .591224D+01,    .592529D+01,    .593773D+01,    .594994D+01,
     .    .596160D+01,    .597272D+01,    .598389D+01,    .599442D+01,
     .    .600504D+01,    .601501D+01,    .602483D+01,    .603457D+01/
 
      DATA (YHI(I),I=441,461)/
     .    .604400D+01,    .605286D+01,    .606153D+01,    .607049D+01,
     .    .607888D+01,    .608728D+01,    .609548D+01,    .610311D+01,
     .    .611124D+01,    .611849D+01,    .612599D+01,    .616131D+01,
     .    .619335D+01,    .622294D+01,    .625043D+01,    .627573D+01,
     .    .629957D+01,    .632199D+01,    .634296D+01,    .636293D+01,
     .    .634546D+01/
 
C--PSEUDOSCALAR HIGGS
 
      DATA (YAR(I),I=  1, 40)/
     .    .000000D+00,    .107656D+00,    .194942D+00,    .275887D+00,
     .    .353426D+00,    .428935D+00,    .503272D+00,    .650573D+00,
     .    .724325D+00,    .798564D+00,    .873565D+00,    .949580D+00,
     .    .102686D+01,    .118623D+01,    .126885D+01,    .135380D+01,
     .    .144141D+01,    .153202D+01,    .162602D+01,    .172387D+01,
     .    .182608D+01,    .193324D+01,    .204604D+01,    .216533D+01,
     .    .229211D+01,    .242760D+01,    .257333D+01,    .290384D+01,
     .    .309442D+01,    .330751D+01,    .354950D+01,    .382982D+01,
     .    .416330D+01,    .457506D+01,    .511299D+01,    .588684D+01,
     .    .725736D+01,    .747117D+01,    .771196D+01,    .798718D+01/
 
      DATA (YAR(I),I= 41, 80)/
     .    .830784D+01,    .869114D+01,    .916618D+01,    .978804D+01,
     .    .106820D+02,    .122546D+02,    .178048D+02,    .236781D+02,
     .    .297057D+02,    .296562D+02,    .235571D+02,    .175254D+02,
     .    .117300D+02,    .100755D+02,    .913916D+01,    .849048D+01,
     .    .799727D+01,    .760054D+01,    .727093D+01,    .698845D+01,
     .    .674528D+01,    .650874D+01,    .515935D+01,    .441231D+01,
     .    .390589D+01,    .352608D+01,    .322386D+01,    .297584D+01,
     .    .276405D+01,    .258053D+01,    .242000D+01,    .227592D+01,
     .    .214372D+01,    .202964D+01,    .192291D+01,    .182449D+01,
     .    .173320D+01,    .164576D+01,    .156871D+01,    .149631D+01/
 
      DATA (YAR(I),I= 81,120)/
     .    .142598D+01,    .136194D+01,    .128150D+01,    .124197D+01,
     .    .118367D+01,    .112959D+01,    .108519D+01,    .103781D+01,
     .    .992390D+00,    .950458D+00,    .907251D+00,    .867939D+00,
     .    .829946D+00,    .793247D+00,    .757606D+00,    .723783D+00,
     .    .693868D+00,    .659531D+00,    .629318D+00,    .593835D+00,
     .    .570896D+00,    .543902D+00,    .517649D+00,    .492601D+00,
     .    .464758D+00,    .442888D+00,    .419924D+00,    .397286D+00,
     .    .374920D+00,    .350712D+00,    .331806D+00,    .312784D+00,
     .    .292391D+00,    .274371D+00,    .255795D+00,    .237467D+00,
     .    .219649D+00,    .200005D+00,    .184904D+00,    .168905D+00/
 
      DATA (YAR(I),I=121,160)/
     .    .150404D+00,    .793464D-01,    .129775D-01,   -.473339D-01,
     .   -.101498D+00,   -.149885D+00,   -.193879D+00,   -.240999D+00,
     .   -.273074D+00,   -.308054D+00,   -.340012D+00,   -.374087D+00,
     .   -.397323D+00,   -.423404D+00,   -.449040D+00,   -.470082D+00,
     .   -.491030D+00,   -.511038D+00,   -.529745D+00,   -.549275D+00,
     .   -.564035D+00,   -.594766D+00,   -.623350D+00,   -.647103D+00,
     .   -.669587D+00,   -.690776D+00,   -.708531D+00,   -.725404D+00,
     .   -.741622D+00,   -.758005D+00,   -.768911D+00,   -.781295D+00,
     .   -.794216D+00,   -.807817D+00,   -.812880D+00,   -.822152D+00,
     .   -.830415D+00,   -.837985D+00,   -.845843D+00,   -.852857D+00/
 
      DATA (YAR(I),I=161,200)/
     .   -.859145D+00,   -.865281D+00,   -.868954D+00,   -.876436D+00,
     .   -.880973D+00,   -.886083D+00,   -.890093D+00,   -.894595D+00,
     .   -.898435D+00,   -.902323D+00,   -.905452D+00,   -.910223D+00,
     .   -.907414D+00,   -.915306D+00,   -.917711D+00,   -.920608D+00,
     .   -.915934D+00,   -.924456D+00,   -.927364D+00,   -.929840D+00,
     .   -.931070D+00,   -.933566D+00,   -.934447D+00,   -.936542D+00,
     .   -.938315D+00,   -.972096D+00,   -.941086D+00,   -.942301D+00,
     .   -.944071D+00,   -.943124D+00,   -.946258D+00,   -.948062D+00,
     .   -.948630D+00,   -.948933D+00,   -.949462D+00,   -.950903D+00,
     .   -.951383D+00,   -.952741D+00,   -.952964D+00,   -.953502D+00/
 
      DATA (YAR(I),I=201,240)/
     .   -.953658D+00,   -.955104D+00,   -.955375D+00,   -.956352D+00,
     .   -.955862D+00,   -.957149D+00,   -.955979D+00,   -.957350D+00,
     .   -.957791D+00,   -.958320D+00,   -.955079D+00,   -.957140D+00,
     .   -.958460D+00,   -.958561D+00,   -.956656D+00,   -.959449D+00,
     .   -.958093D+00,   -.959547D+00,   -.959046D+00,   -.959687D+00,
     .   -.957065D+00,   -.959656D+00,   -.959087D+00,   -.956125D+00,
     .   -.957608D+00,   -.953196D+00,   -.953894D+00,   -.953363D+00,
     .   -.951781D+00,   -.949669D+00,   -.940507D+00,   -.945853D+00,
     .   -.939752D+00,   -.941372D+00,   -.932368D+00,   -.937784D+00,
     .   -.934341D+00,   -.932752D+00,   -.931438D+00,   -.928019D+00/
 
      DATA (YAR(I),I=241,280)/
     .   -.926596D+00,   -.922441D+00,   -.918783D+00,   -.913593D+00,
     .   -.907643D+00,   -.905388D+00,   -.900065D+00,   -.897836D+00,
     .   -.889500D+00,   -.889610D+00,   -.886329D+00,   -.875994D+00,
     .   -.877255D+00,   -.874503D+00,   -.862799D+00,   -.868597D+00,
     .   -.864079D+00,   -.859546D+00,   -.857609D+00,   -.846104D+00,
     .   -.844531D+00,   -.818567D+00,   -.842278D+00,   -.826725D+00,
     .   -.836027D+00,   -.818729D+00,   -.832092D+00,   -.862463D+00,
     .   -.822097D+00,   -.916217D+00,   -.820624D+00,   -.806958D+00,
     .   -.796693D+00,   -.761872D+00,   -.778348D+00,   -.764977D+00,
     .   -.685441D+00,   -.740841D+00,   -.728767D+00,   -.713525D+00/
 
      DATA (YAR(I),I=281,320)/
     .   -.716847D+00,   -.752733D+00,   -.712400D+00,   -.703534D+00,
     .   -.697167D+00,   -.691064D+00,   -.677828D+00,   -.667727D+00,
     .   -.659462D+00,   -.668990D+00,   -.650225D+00,   -.671173D+00,
     .   -.594823D+00,   -.641741D+00,   -.647212D+00,   -.641213D+00,
     .   -.615130D+00,   -.600086D+00,   -.447458D+00,   -.641688D+00,
     .   -.627802D+00,   -.606599D+00,   -.622006D+00,   -.543438D+00,
     .   -.617197D+00,   -.583968D+00,   -.546640D+00,   -.584638D+00,
     .   -.594023D+00,   -.592840D+00,   -.585629D+00,   -.583364D+00,
     .   -.559699D+00,   -.559065D+00,   -.621649D+00,   -.566181D+00,
     .   -.567551D+00,   -.515718D+00,   -.566098D+00,   -.543432D+00/
 
      DATA (YAR(I),I=321,360)/
     .   -.523345D+00,   -.558599D+00,   -.556164D+00,   -.553926D+00,
     .   -.567279D+00,   -.578838D+00,   -.547798D+00,   -.481896D+00,
     .   -.477980D+00,   -.483052D+00,   -.540206D+00,   -.502885D+00,
     .   -.525146D+00,   -.556143D+00,   -.513785D+00,   -.494994D+00,
     .   -.487872D+00,   -.682093D+00,   -.498118D+00,   -.495233D+00,
     .   -.492653D+00,   -.490356D+00,   -.488291D+00,   -.486450D+00,
     .   -.484802D+00,   -.483332D+00,   -.482014D+00,   -.480843D+00,
     .   -.479798D+00,   -.478877D+00,   -.478063D+00,   -.477346D+00,
     .   -.476718D+00,   -.476175D+00,   -.475710D+00,   -.475304D+00,
     .   -.474928D+00,   -.474722D+00,   -.474506D+00,   -.474346D+00/
 
      DATA (YAR(I),I=361,400)/
     .   -.474242D+00,   -.474150D+00,   -.474221D+00,   -.474435D+00,
     .   -.474766D+00,   -.475205D+00,   -.475736D+00,   -.476356D+00,
     .   -.477056D+00,   -.477815D+00,   -.478630D+00,   -.479506D+00,
     .   -.480433D+00,   -.481391D+00,   -.482397D+00,   -.483423D+00,
     .   -.484493D+00,   -.485535D+00,   -.486697D+00,   -.487845D+00,
     .   -.489006D+00,   -.490193D+00,   -.491389D+00,   -.492597D+00,
     .   -.493819D+00,   -.495061D+00,   -.496302D+00,   -.497554D+00,
     .   -.498820D+00,   -.500085D+00,   -.501361D+00,   -.507820D+00,
     .   -.514310D+00,   -.520808D+00,   -.525807D+00,   -.533729D+00,
     .   -.540084D+00,   -.544610D+00,   -.548574D+00,   -.556209D+00/
 
      DATA (YAR(I),I=401,440)/
     .   -.524880D+00,   -.567412D+00,   -.573194D+00,   -.578918D+00,
     .   -.584525D+00,   -.590055D+00,   -.595466D+00,   -.600826D+00,
     .   -.606087D+00,   -.611275D+00,   -.616402D+00,   -.621445D+00,
     .   -.626397D+00,   -.631270D+00,   -.636056D+00,   -.640845D+00,
     .   -.645705D+00,   -.650367D+00,   -.654785D+00,   -.659422D+00,
     .   -.663754D+00,   -.672494D+00,   -.680673D+00,   -.688935D+00,
     .   -.697321D+00,   -.705395D+00,   -.713055D+00,   -.720269D+00,
     .   -.727981D+00,   -.734908D+00,   -.742159D+00,   -.748931D+00,
     .   -.755854D+00,   -.763004D+00,   -.769254D+00,   -.776040D+00,
     .   -.781926D+00,   -.788392D+00,   -.794570D+00,   -.800295D+00/
 
      DATA (YAR(I),I=441,461)/
     .   -.806072D+00,   -.812386D+00,   -.818438D+00,   -.823675D+00,
     .   -.829348D+00,   -.834793D+00,   -.840050D+00,   -.845838D+00,
     .   -.850553D+00,   -.856445D+00,   -.861415D+00,   -.885838D+00,
     .   -.909128D+00,   -.931048D+00,   -.951610D+00,   -.971748D+00,
     .   -.990338D+00,   -.100853D+01,   -.102585D+01,   -.104268D+01,
     .   -.104043D+01/
 
      DATA (YAI(I),I=  1, 40)/
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00/
 
      DATA (YAI(I),I= 41, 80)/
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .000000D+00,    .000000D+00,    .000000D+00,
     .    .000000D+00,    .831808D+01,    .818735D+01,    .793295D+01,
     .    .735669D+01,    .710536D+01,    .693703D+01,    .681310D+01,
     .    .670925D+01,    .661927D+01,    .654483D+01,    .647685D+01,
     .    .643295D+01,    .630286D+01,    .600498D+01,    .579388D+01,
     .    .564717D+01,    .553467D+01,    .544441D+01,    .537025D+01,
     .    .530769D+01,    .525096D+01,    .520347D+01,    .515849D+01,
     .    .511609D+01,    .508187D+01,    .504963D+01,    .501822D+01,
     .    .498958D+01,    .495958D+01,    .493670D+01,    .491371D+01/
 
      DATA (YAI(I),I= 81,120)/
     .    .489126D+01,    .486920D+01,    .485160D+01,    .482904D+01,
     .    .480811D+01,    .478834D+01,    .477591D+01,    .476057D+01,
     .    .474342D+01,    .472952D+01,    .471350D+01,    .469884D+01,
     .    .468500D+01,    .467212D+01,    .465891D+01,    .464614D+01,
     .    .463301D+01,    .462255D+01,    .461051D+01,    .459651D+01,
     .    .458887D+01,    .458017D+01,    .456790D+01,    .455739D+01,
     .    .454741D+01,    .453893D+01,    .452841D+01,    .451944D+01,
     .    .451043D+01,    .450054D+01,    .449694D+01,    .448515D+01,
     .    .447638D+01,    .446911D+01,    .446049D+01,    .445191D+01,
     .    .444588D+01,    .443794D+01,    .443099D+01,    .442444D+01/
 
      DATA (YAI(I),I=121,160)/
     .    .442321D+01,    .438172D+01,    .435138D+01,    .432312D+01,
     .    .429941D+01,    .427305D+01,    .425098D+01,    .423017D+01,
     .    .420997D+01,    .419200D+01,    .417470D+01,    .416031D+01,
     .    .414409D+01,    .412862D+01,    .411644D+01,    .410195D+01,
     .    .409040D+01,    .407820D+01,    .406731D+01,    .406133D+01,
     .    .404638D+01,    .402754D+01,    .401066D+01,    .399455D+01,
     .    .397986D+01,    .396667D+01,    .395543D+01,    .394317D+01,
     .    .393537D+01,    .392389D+01,    .391326D+01,    .390402D+01,
     .    .389701D+01,    .383229D+01,    .388176D+01,    .387522D+01,
     .    .386899D+01,    .386309D+01,    .385765D+01,    .385255D+01/
 
      DATA (YAI(I),I=161,200)/
     .    .384771D+01,    .384298D+01,    .384401D+01,    .383470D+01,
     .    .383106D+01,    .382702D+01,    .382344D+01,    .382019D+01,
     .    .381737D+01,    .381425D+01,    .381164D+01,    .380967D+01,
     .    .380578D+01,    .380396D+01,    .380193D+01,    .379977D+01,
     .    .380865D+01,    .379938D+01,    .379587D+01,    .379233D+01,
     .    .379054D+01,    .378916D+01,    .378962D+01,    .378775D+01,
     .    .378863D+01,    .372979D+01,    .378345D+01,    .378126D+01,
     .    .378023D+01,    .379038D+01,    .377847D+01,    .377738D+01,
     .    .377673D+01,    .377679D+01,    .377712D+01,    .377444D+01,
     .    .377423D+01,    .377342D+01,    .377269D+01,    .377261D+01/
 
      DATA (YAI(I),I=201,240)/
     .    .377282D+01,    .377131D+01,    .377087D+01,    .377125D+01,
     .    .377041D+01,    .377099D+01,    .377081D+01,    .376976D+01,
     .    .376916D+01,    .376887D+01,    .377678D+01,    .376827D+01,
     .    .376916D+01,    .376794D+01,    .377074D+01,    .376834D+01,
     .    .376720D+01,    .376799D+01,    .376771D+01,    .376816D+01,
     .    .376716D+01,    .376851D+01,    .376932D+01,    .377553D+01,
     .    .376962D+01,    .377984D+01,    .377755D+01,    .377704D+01,
     .    .377856D+01,    .378131D+01,    .378992D+01,    .378534D+01,
     .    .379472D+01,    .379126D+01,    .380889D+01,    .379477D+01,
     .    .379941D+01,    .380160D+01,    .380212D+01,    .380510D+01/
 
      DATA (YAI(I),I=241,280)/
     .    .380747D+01,    .381337D+01,    .381797D+01,    .382492D+01,
     .    .383221D+01,    .383504D+01,    .384247D+01,    .384455D+01,
     .    .384575D+01,    .385171D+01,    .385889D+01,    .387430D+01,
     .    .386935D+01,    .387477D+01,    .388395D+01,    .388362D+01,
     .    .388764D+01,    .389526D+01,    .389633D+01,    .390457D+01,
     .    .391287D+01,    .392254D+01,    .391648D+01,    .391312D+01,
     .    .392499D+01,    .393347D+01,    .393165D+01,    .389131D+01,
     .    .394454D+01,    .372588D+01,    .394937D+01,    .396644D+01,
     .    .398516D+01,    .401205D+01,    .402217D+01,    .403371D+01,
     .    .411495D+01,    .406398D+01,    .408141D+01,    .410076D+01/
 
      DATA (YAI(I),I=281,320)/
     .    .410373D+01,    .407258D+01,    .412063D+01,    .413559D+01,
     .    .414123D+01,    .415644D+01,    .417849D+01,    .417521D+01,
     .    .417079D+01,    .419390D+01,    .420584D+01,    .421677D+01,
     .    .420495D+01,    .422654D+01,    .423586D+01,    .424791D+01,
     .    .423930D+01,    .423524D+01,    .442081D+01,    .427958D+01,
     .    .428237D+01,    .430291D+01,    .431084D+01,    .434019D+01,
     .    .432980D+01,    .435971D+01,    .430316D+01,    .437033D+01,
     .    .436499D+01,    .438560D+01,    .438429D+01,    .438911D+01,
     .    .441759D+01,    .443445D+01,    .437106D+01,    .444441D+01,
     .    .444318D+01,    .437607D+01,    .447355D+01,    .449308D+01/
 
      DATA (YAI(I),I=321,360)/
     .    .448290D+01,    .449664D+01,    .450408D+01,    .451127D+01,
     .    .448290D+01,    .448202D+01,    .453184D+01,    .457917D+01,
     .    .446108D+01,    .455233D+01,    .455773D+01,    .459437D+01,
     .    .461470D+01,    .465485D+01,    .466350D+01,    .471133D+01,
     .    .474299D+01,    .456703D+01,    .474420D+01,    .476173D+01,
     .    .477841D+01,    .479434D+01,    .480955D+01,    .482413D+01,
     .    .483812D+01,    .485157D+01,    .486452D+01,    .487701D+01,
     .    .488906D+01,    .490071D+01,    .491198D+01,    .492291D+01,
     .    .493350D+01,    .494378D+01,    .495376D+01,    .496346D+01,
     .    .497283D+01,    .498212D+01,    .499108D+01,    .499983D+01/
 
      DATA (YAI(I),I=361,400)/
     .    .500836D+01,    .502482D+01,    .504054D+01,    .505560D+01,
     .    .507003D+01,    .508390D+01,    .509724D+01,    .511009D+01,
     .    .512250D+01,    .513449D+01,    .514607D+01,    .515730D+01,
     .    .516817D+01,    .517873D+01,    .518898D+01,    .519894D+01,
     .    .520862D+01,    .521810D+01,    .522725D+01,    .523620D+01,
     .    .524493D+01,    .525347D+01,    .526178D+01,    .526993D+01,
     .    .527788D+01,    .528564D+01,    .529326D+01,    .530072D+01,
     .    .530802D+01,    .531517D+01,    .532218D+01,    .535532D+01,
     .    .538563D+01,    .541358D+01,    .544040D+01,    .546366D+01,
     .    .548630D+01,    .550863D+01,    .552521D+01,    .554307D+01/
 
      DATA (YAI(I),I=401,440)/
     .    .558822D+01,    .558532D+01,    .560178D+01,    .561753D+01,
     .    .563262D+01,    .564707D+01,    .566101D+01,    .567440D+01,
     .    .568734D+01,    .569980D+01,    .571188D+01,    .572354D+01,
     .    .573486D+01,    .574583D+01,    .575648D+01,    .576683D+01,
     .    .577676D+01,    .578653D+01,    .579610D+01,    .580532D+01,
     .    .581445D+01,    .583185D+01,    .584868D+01,    .586456D+01,
     .    .587968D+01,    .589419D+01,    .590825D+01,    .592198D+01,
     .    .593491D+01,    .594762D+01,    .595974D+01,    .597162D+01,
     .    .598299D+01,    .599384D+01,    .600473D+01,    .601500D+01,
     .    .602536D+01,    .603508D+01,    .604467D+01,    .605417D+01/
 
      DATA (YAI(I),I=441,461)/
     .    .606338D+01,    .607204D+01,    .608051D+01,    .608925D+01,
     .    .609746D+01,    .610566D+01,    .611368D+01,    .612114D+01,
     .    .612908D+01,    .613618D+01,    .614351D+01,    .617806D+01,
     .    .620943D+01,    .623841D+01,    .626535D+01,    .629016D+01,
     .    .631353D+01,    .633554D+01,    .635612D+01,    .637573D+01,
     .    .635841D+01/
 
      END

      BLOCKDATA CVIRTSQ_HDEC
C--DATA OF VIRTUAL CORRECTIONS TO SQUARK LOOPS
      PARAMETER(NN=999)
      IMPLICIT DOUBLE PRECISION (A-B,D-H,O-Z), COMPLEX*16 (C)
      COMMON/RESINTSQ_HDEC/XX(NN),YHR(NN),YHI(NN)

      DATA ( XX(I),I=  1, 40)/
     .   0.000000D+00,   0.100000D+00,   0.200000D+00,   0.300000D+00,
     .   0.400000D+00,   0.500000D+00,   0.600000D+00,   0.800000D+00,
     .   0.900000D+00,   0.100000D+01,   0.110000D+01,   0.120000D+01,
     .   0.130000D+01,   0.150000D+01,   0.160000D+01,   0.170000D+01,
     .   0.180000D+01,   0.190000D+01,   0.200000D+01,   0.210000D+01,
     .   0.220000D+01,   0.230000D+01,   0.240000D+01,   0.250000D+01,
     .   0.260000D+01,   0.270000D+01,   0.280000D+01,   0.300000D+01,
     .   0.310000D+01,   0.320000D+01,   0.330000D+01,   0.340000D+01,
     .   0.350000D+01,   0.360000D+01,   0.370000D+01,   0.380000D+01,
     .   0.390000D+01,   0.391000D+01,   0.392000D+01,   0.393000D+01/

      DATA ( XX(I),I= 41, 80)/
     .   0.394000D+01,   0.395000D+01,   0.396000D+01,   0.397000D+01,
     .   0.398000D+01,   0.399000D+01,   0.399900D+01,   0.399990D+01,
     .   0.399999D+01,   0.400001D+01,   0.400010D+01,   0.400100D+01,
     .   0.401000D+01,   0.402000D+01,   0.403000D+01,   0.404000D+01,
     .   0.405000D+01,   0.406000D+01,   0.407000D+01,   0.408000D+01,
     .   0.409000D+01,   0.410000D+01,   0.420000D+01,   0.430000D+01,
     .   0.440000D+01,   0.450000D+01,   0.460000D+01,   0.470000D+01,
     .   0.480000D+01,   0.490000D+01,   0.500000D+01,   0.510000D+01,
     .   0.520000D+01,   0.530000D+01,   0.540000D+01,   0.550000D+01,
     .   0.560000D+01,   0.570000D+01,   0.580000D+01,   0.590000D+01/

      DATA ( XX(I),I= 81,120)/
     .   0.600000D+01,   0.610000D+01,   0.620000D+01,   0.630000D+01,
     .   0.640000D+01,   0.650000D+01,   0.660000D+01,   0.670000D+01,
     .   0.680000D+01,   0.690000D+01,   0.700000D+01,   0.710000D+01,
     .   0.720000D+01,   0.730000D+01,   0.740000D+01,   0.750000D+01,
     .   0.760000D+01,   0.770000D+01,   0.780000D+01,   0.790000D+01,
     .   0.800000D+01,   0.810000D+01,   0.820000D+01,   0.830000D+01,
     .   0.840000D+01,   0.850000D+01,   0.860000D+01,   0.870000D+01,
     .   0.880000D+01,   0.890000D+01,   0.900000D+01,   0.910000D+01,
     .   0.920000D+01,   0.930000D+01,   0.940000D+01,   0.950000D+01,
     .   0.960000D+01,   0.970000D+01,   0.980000D+01,   0.990000D+01/

      DATA ( XX(I),I=121,160)/
     .   0.100000D+02,   0.105000D+02,   0.110000D+02,   0.115000D+02,
     .   0.120000D+02,   0.125000D+02,   0.130000D+02,   0.135000D+02,
     .   0.140000D+02,   0.145000D+02,   0.150000D+02,   0.155000D+02,
     .   0.160000D+02,   0.165000D+02,   0.170000D+02,   0.175000D+02,
     .   0.180000D+02,   0.185000D+02,   0.190000D+02,   0.195000D+02,
     .   0.200000D+02,   0.210000D+02,   0.220000D+02,   0.230000D+02,
     .   0.240000D+02,   0.250000D+02,   0.260000D+02,   0.270000D+02,
     .   0.280000D+02,   0.290000D+02,   0.300000D+02,   0.310000D+02,
     .   0.320000D+02,   0.330000D+02,   0.340000D+02,   0.350000D+02,
     .   0.360000D+02,   0.370000D+02,   0.380000D+02,   0.390000D+02/

      DATA ( XX(I),I=161,200)/
     .   0.400000D+02,   0.410000D+02,   0.420000D+02,   0.430000D+02,
     .   0.440000D+02,   0.450000D+02,   0.460000D+02,   0.470000D+02,
     .   0.480000D+02,   0.490000D+02,   0.500000D+02,   0.510000D+02,
     .   0.520000D+02,   0.530000D+02,   0.540000D+02,   0.550000D+02,
     .   0.560000D+02,   0.570000D+02,   0.580000D+02,   0.590000D+02,
     .   0.600000D+02,   0.610000D+02,   0.620000D+02,   0.630000D+02,
     .   0.640000D+02,   0.650000D+02,   0.660000D+02,   0.670000D+02,
     .   0.680000D+02,   0.690000D+02,   0.700000D+02,   0.710000D+02,
     .   0.720000D+02,   0.730000D+02,   0.740000D+02,   0.750000D+02,
     .   0.760000D+02,   0.770000D+02,   0.780000D+02,   0.790000D+02/

      DATA ( XX(I),I=201,240)/
     .   0.800000D+02,   0.810000D+02,   0.820000D+02,   0.830000D+02,
     .   0.840000D+02,   0.850000D+02,   0.860000D+02,   0.870000D+02,
     .   0.880000D+02,   0.890000D+02,   0.900000D+02,   0.910000D+02,
     .   0.920000D+02,   0.930000D+02,   0.940000D+02,   0.950000D+02,
     .   0.960000D+02,   0.970000D+02,   0.980000D+02,   0.990000D+02,
     .   0.100000D+03,   0.105000D+03,   0.110000D+03,   0.115000D+03,
     .   0.120000D+03,   0.125000D+03,   0.130000D+03,   0.135000D+03,
     .   0.140000D+03,   0.145000D+03,   0.150000D+03,   0.155000D+03,
     .   0.160000D+03,   0.165000D+03,   0.170000D+03,   0.175000D+03,
     .   0.180000D+03,   0.185000D+03,   0.190000D+03,   0.195000D+03/

      DATA ( XX(I),I=241,280)/
     .   0.200000D+03,   0.210000D+03,   0.220000D+03,   0.230000D+03,
     .   0.240000D+03,   0.250000D+03,   0.260000D+03,   0.270000D+03,
     .   0.280000D+03,   0.290000D+03,   0.300000D+03,   0.310000D+03,
     .   0.320000D+03,   0.330000D+03,   0.340000D+03,   0.350000D+03,
     .   0.360000D+03,   0.370000D+03,   0.380000D+03,   0.390000D+03,
     .   0.400000D+03,   0.410000D+03,   0.420000D+03,   0.430000D+03,
     .   0.440000D+03,   0.450000D+03,   0.460000D+03,   0.470000D+03,
     .   0.480000D+03,   0.490000D+03,   0.500000D+03,   0.550000D+03,
     .   0.600000D+03,   0.650000D+03,   0.700000D+03,   0.750000D+03,
     .   0.800000D+03,   0.850000D+03,   0.900000D+03,   0.950000D+03/

      DATA ( XX(I),I=281,320)/
     .   0.100000D+04,   0.105000D+04,   0.110000D+04,   0.115000D+04,
     .   0.120000D+04,   0.125000D+04,   0.130000D+04,   0.135000D+04,
     .   0.140000D+04,   0.145000D+04,   0.150000D+04,   0.155000D+04,
     .   0.160000D+04,   0.165000D+04,   0.170000D+04,   0.175000D+04,
     .   0.180000D+04,   0.185000D+04,   0.190000D+04,   0.195000D+04,
     .   0.200000D+04,   0.210000D+04,   0.220000D+04,   0.230000D+04,
     .   0.240000D+04,   0.250000D+04,   0.260000D+04,   0.270000D+04,
     .   0.280000D+04,   0.290000D+04,   0.300000D+04,   0.310000D+04,
     .   0.320000D+04,   0.330000D+04,   0.340000D+04,   0.350000D+04,
     .   0.360000D+04,   0.370000D+04,   0.380000D+04,   0.390000D+04/

      DATA ( XX(I),I=321,360)/
     .   0.400000D+04,   0.410000D+04,   0.420000D+04,   0.430000D+04,
     .   0.440000D+04,   0.450000D+04,   0.460000D+04,   0.470000D+04,
     .   0.480000D+04,   0.490000D+04,   0.500000D+04,   0.550000D+04,
     .   0.600000D+04,   0.650000D+04,   0.700000D+04,   0.750000D+04,
     .   0.800000D+04,   0.850000D+04,   0.900000D+04,   0.950000D+04,
     .   0.100000D+05,   0.105000D+05,   0.110000D+05,   0.115000D+05,
     .   0.120000D+05,   0.125000D+05,   0.130000D+05,   0.135000D+05,
     .   0.140000D+05,   0.145000D+05,   0.150000D+05,   0.155000D+05,
     .   0.160000D+05,   0.165000D+05,   0.170000D+05,   0.175000D+05,
     .   0.180000D+05,   0.185000D+05,   0.190000D+05,   0.195000D+05/

      DATA ( XX(I),I=361,400)/
     .   0.200000D+05,   0.210000D+05,   0.220000D+05,   0.230000D+05,
     .   0.240000D+05,   0.250000D+05,   0.260000D+05,   0.270000D+05,
     .   0.280000D+05,   0.290000D+05,   0.300000D+05,   0.310000D+05,
     .   0.320000D+05,   0.330000D+05,   0.340000D+05,   0.350000D+05,
     .   0.360000D+05,   0.370000D+05,   0.380000D+05,   0.390000D+05,
     .   0.400000D+05,   0.410000D+05,   0.420000D+05,   0.430000D+05,
     .   0.440000D+05,   0.450000D+05,   0.460000D+05,   0.470000D+05,
     .   0.480000D+05,   0.490000D+05,   0.500000D+05,   0.550000D+05,
     .   0.600000D+05,   0.650000D+05,   0.700000D+05,   0.750000D+05,
     .   0.800000D+05,   0.850000D+05,   0.900000D+05,   0.950000D+05/

      DATA ( XX(I),I=401,440)/
     .   0.100000D+06,   0.105000D+06,   0.110000D+06,   0.115000D+06,
     .   0.120000D+06,   0.125000D+06,   0.130000D+06,   0.135000D+06,
     .   0.140000D+06,   0.145000D+06,   0.150000D+06,   0.155000D+06,
     .   0.160000D+06,   0.165000D+06,   0.170000D+06,   0.175000D+06,
     .   0.180000D+06,   0.185000D+06,   0.190000D+06,   0.195000D+06,
     .   0.200000D+06,   0.210000D+06,   0.220000D+06,   0.230000D+06,
     .   0.240000D+06,   0.250000D+06,   0.260000D+06,   0.270000D+06,
     .   0.280000D+06,   0.290000D+06,   0.300000D+06,   0.310000D+06,
     .   0.320000D+06,   0.330000D+06,   0.340000D+06,   0.350000D+06,
     .   0.360000D+06,   0.370000D+06,   0.380000D+06,   0.390000D+06/

      DATA ( XX(I),I=441,461)/
     .   0.400000D+06,   0.410000D+06,   0.420000D+06,   0.430000D+06,
     .   0.440000D+06,   0.450000D+06,   0.460000D+06,   0.470000D+06,
     .   0.480000D+06,   0.490000D+06,   0.500000D+06,   0.550000D+06,
     .   0.600000D+06,   0.650000D+06,   0.700000D+06,   0.750000D+06,
     .   0.800000D+06,   0.850000D+06,   0.900000D+06,   0.950000D+06,
     .   0.100000D+07/

C--SCALAR HIGGS

      DATA (YHR(I),I=  1, 40)/
     .   0.300000D+01,   0.309524D+01,   0.317521D+01,   0.325029D+01,
     .   0.332320D+01,   0.339471D+01,   0.346593D+01,   0.360889D+01,
     .   0.368136D+01,   0.375489D+01,   0.382976D+01,   0.390620D+01,
     .   0.398451D+01,   0.414779D+01,   0.423339D+01,   0.432206D+01,
     .   0.441419D+01,   0.451021D+01,   0.461059D+01,   0.471590D+01,
     .   0.482678D+01,   0.494399D+01,   0.506842D+01,   0.520114D+01,
     .   0.534347D+01,   0.549701D+01,   0.566377D+01,   0.604800D+01,
     .   0.627328D+01,   0.652827D+01,   0.682172D+01,   0.716664D+01,
     .   0.758365D+01,   0.810814D+01,   0.880835D+01,   0.984304D+01,
     .   0.117448D+02,   0.120485D+02,   0.123927D+02,   0.127886D+02/

      DATA (YHR(I),I= 41, 80)/
     .   0.132533D+02,   0.138132D+02,   0.145134D+02,   0.154398D+02,
     .   0.167893D+02,   0.192067D+02,   0.280423D+02,   0.376825D+02,
     .   0.477165D+02,   0.475835D+02,   0.373653D+02,   0.273433D+02,
     .   0.179175D+02,   0.153023D+02,   0.138453D+02,   0.128484D+02,
     .   0.120977D+02,   0.114990D+02,   0.110056D+02,   0.105858D+02,
     .   0.102280D+02,   0.987658D+01,   0.794900D+01,   0.692415D+01,
     .   0.625229D+01,   0.576234D+01,   0.538220D+01,   0.507709D+01,
     .   0.482246D+01,   0.460521D+01,   0.441925D+01,   0.425440D+01,
     .   0.410537D+01,   0.397907D+01,   0.386278D+01,   0.375635D+01,
     .   0.365915D+01,   0.356636D+01,   0.348677D+01,   0.341222D+01/

      DATA (YHR(I),I= 81,120)/
     .   0.334078D+01,   0.327553D+01,   0.320082D+01,   0.315587D+01,
     .   0.309820D+01,   0.304496D+01,   0.300288D+01,   0.295784D+01,
     .   0.291392D+01,   0.287449D+01,   0.283367D+01,   0.279662D+01,
     .   0.276127D+01,   0.272764D+01,   0.269492D+01,   0.266394D+01,
     .   0.263562D+01,   0.260605D+01,   0.257864D+01,   0.254730D+01,
     .   0.252746D+01,   0.250395D+01,   0.247986D+01,   0.245754D+01,
     .   0.243402D+01,   0.241493D+01,   0.239441D+01,   0.237498D+01,
     .   0.235586D+01,   0.233546D+01,   0.232115D+01,   0.230305D+01,
     .   0.228575D+01,   0.227058D+01,   0.225461D+01,   0.223890D+01,
     .   0.222478D+01,   0.220893D+01,   0.219603D+01,   0.218294D+01/

      DATA (YHR(I),I=121,160)/
     .   0.217112D+01,   0.210819D+01,   0.205447D+01,   0.200627D+01,
     .   0.196435D+01,   0.192505D+01,   0.189058D+01,   0.185636D+01,
     .   0.182929D+01,   0.180271D+01,   0.177821D+01,   0.175473D+01,
     .   0.173495D+01,   0.171493D+01,   0.169679D+01,   0.167970D+01,
     .   0.166413D+01,   0.164894D+01,   0.163495D+01,   0.162280D+01,
     .   0.160909D+01,   0.158600D+01,   0.156507D+01,   0.154648D+01,
     .   0.152933D+01,   0.151360D+01,   0.149985D+01,   0.148643D+01,
     .   0.147496D+01,   0.146268D+01,   0.145226D+01,   0.144221D+01,
     .   0.143296D+01,   0.140754D+01,   0.141637D+01,   0.140872D+01,
     .   0.140154D+01,   0.139476D+01,   0.138822D+01,   0.138207D+01/

      DATA (YHR(I),I=161,200)/
     .   0.137628D+01,   0.137068D+01,   0.136707D+01,   0.136034D+01,
     .   0.135564D+01,   0.135085D+01,   0.134645D+01,   0.134215D+01,
     .   0.133814D+01,   0.133413D+01,   0.133044D+01,   0.132671D+01,
     .   0.132381D+01,   0.131977D+01,   0.131659D+01,   0.131337D+01,
     .   0.131365D+01,   0.130821D+01,   0.130487D+01,   0.130166D+01,
     .   0.129902D+01,   0.129634D+01,   0.129429D+01,   0.129165D+01,
     .   0.128963D+01,   0.127180D+01,   0.128448D+01,   0.128206D+01,
     .   0.127983D+01,   0.128004D+01,   0.127569D+01,   0.127354D+01,
     .   0.127166D+01,   0.126997D+01,   0.126833D+01,   0.126606D+01,
     .   0.126438D+01,   0.126251D+01,   0.126082D+01,   0.125923D+01/

      DATA (YHR(I),I=201,240)/
     .   0.125775D+01,   0.125585D+01,   0.125429D+01,   0.125281D+01,
     .   0.125132D+01,   0.124988D+01,   0.124861D+01,   0.124693D+01,
     .   0.124545D+01,   0.124403D+01,   0.124432D+01,   0.124148D+01,
     .   0.124020D+01,   0.123875D+01,   0.123815D+01,   0.123626D+01,
     .   0.123503D+01,   0.123380D+01,   0.123263D+01,   0.123147D+01,
     .   0.123045D+01,   0.122482D+01,   0.121974D+01,   0.121588D+01,
     .   0.121022D+01,   0.120742D+01,   0.120275D+01,   0.119862D+01,
     .   0.119500D+01,   0.119173D+01,   0.118982D+01,   0.118539D+01,
     .   0.118352D+01,   0.117979D+01,   0.117916D+01,   0.117430D+01,
     .   0.117211D+01,   0.116962D+01,   0.116704D+01,   0.116493D+01/

      DATA (YHR(I),I=241,280)/
     .   0.116269D+01,   0.115861D+01,   0.115463D+01,   0.115118D+01,
     .   0.114799D+01,   0.114440D+01,   0.114153D+01,   0.113824D+01,
     .   0.113538D+01,   0.113253D+01,   0.113007D+01,   0.112864D+01,
     .   0.112535D+01,   0.112306D+01,   0.112154D+01,   0.111865D+01,
     .   0.111662D+01,   0.111489D+01,   0.111272D+01,   0.111147D+01,
     .   0.110982D+01,   0.110939D+01,   0.110595D+01,   0.110448D+01,
     .   0.110276D+01,   0.110205D+01,   0.109958D+01,   0.109461D+01,
     .   0.109713D+01,   0.108140D+01,   0.109411D+01,   0.108785D+01,
     .   0.108230D+01,   0.107852D+01,   0.107291D+01,   0.106880D+01,
     .   0.106926D+01,   0.106185D+01,   0.105887D+01,   0.105628D+01/

      DATA (YHR(I),I=281,320)/
     .   0.105297D+01,   0.104821D+01,   0.104757D+01,   0.104545D+01,
     .   0.104320D+01,   0.104129D+01,   0.103979D+01,   0.103779D+01,
     .   0.103583D+01,   0.103417D+01,   0.103293D+01,   0.103098D+01,
     .   0.103052D+01,   0.102844D+01,   0.102697D+01,   0.102581D+01,
     .   0.102471D+01,   0.102354D+01,   0.102770D+01,   0.102101D+01,
     .   0.102007D+01,   0.101842D+01,   0.101617D+01,   0.101572D+01,
     .   0.101264D+01,   0.101173D+01,   0.100988D+01,   0.100862D+01,
     .   0.100697D+01,   0.100582D+01,   0.100457D+01,   0.100339D+01,
     .   0.100276D+01,   0.100179D+01,   0.999388D+00,   0.999661D+00,
     .   0.998634D+00,   0.997609D+00,   0.997038D+00,   0.996556D+00/

      DATA (YHR(I),I=321,360)/
     .   0.995811D+00,   0.994757D+00,   0.994059D+00,   0.993378D+00,
     .   0.992304D+00,   0.991494D+00,   0.991462D+00,   0.991730D+00,
     .   0.990259D+00,   0.990246D+00,   0.989202D+00,   0.986998D+00,
     .   0.984573D+00,   0.982508D+00,   0.980999D+00,   0.979709D+00,
     .   0.978412D+00,   0.975199D+00,   0.975792D+00,   0.974766D+00,
     .   0.973823D+00,   0.972951D+00,   0.972143D+00,   0.971391D+00,
     .   0.970690D+00,   0.970034D+00,   0.969419D+00,   0.968841D+00,
     .   0.968296D+00,   0.967782D+00,   0.967296D+00,   0.966835D+00,
     .   0.966398D+00,   0.965982D+00,   0.965587D+00,   0.965210D+00,
     .   0.964850D+00,   0.964506D+00,   0.964177D+00,   0.963862D+00/

      DATA (YHR(I),I=361,400)/
     .   0.963560D+00,   0.962991D+00,   0.962465D+00,   0.961977D+00,
     .   0.961523D+00,   0.961100D+00,   0.960703D+00,   0.960331D+00,
     .   0.959981D+00,   0.959652D+00,   0.959340D+00,   0.959046D+00,
     .   0.958767D+00,   0.958503D+00,   0.958251D+00,   0.958011D+00,
     .   0.957783D+00,   0.957566D+00,   0.957357D+00,   0.957158D+00,
     .   0.956968D+00,   0.956785D+00,   0.956609D+00,   0.956441D+00,
     .   0.956279D+00,   0.956123D+00,   0.955973D+00,   0.955828D+00,
     .   0.955689D+00,   0.955554D+00,   0.955424D+00,   0.954834D+00,
     .   0.954330D+00,   0.953892D+00,   0.953511D+00,   0.953170D+00,
     .   0.952868D+00,   0.952600D+00,   0.952355D+00,   0.952131D+00/

      DATA (YHR(I),I=401,440)/
     .   0.951971D+00,   0.951752D+00,   0.951581D+00,   0.951422D+00,
     .   0.951275D+00,   0.951139D+00,   0.951012D+00,   0.950893D+00,
     .   0.950781D+00,   0.950677D+00,   0.950578D+00,   0.950485D+00,
     .   0.950397D+00,   0.950314D+00,   0.950236D+00,   0.950161D+00,
     .   0.950090D+00,   0.950022D+00,   0.949958D+00,   0.949896D+00,
     .   0.949837D+00,   0.949727D+00,   0.949626D+00,   0.949533D+00,
     .   0.949446D+00,   0.949366D+00,   0.949291D+00,   0.949221D+00,
     .   0.949156D+00,   0.949095D+00,   0.949037D+00,   0.948983D+00,
     .   0.948932D+00,   0.948883D+00,   0.948838D+00,   0.948794D+00,
     .   0.948753D+00,   0.948714D+00,   0.948676D+00,   0.948641D+00/

      DATA (YHR(I),I=441,461)/
     .   0.948607D+00,   0.948574D+00,   0.948543D+00,   0.948513D+00,
     .   0.948484D+00,   0.948457D+00,   0.948430D+00,   0.948405D+00,
     .   0.948381D+00,   0.948357D+00,   0.948334D+00,   0.948232D+00,
     .   0.948146D+00,   0.948072D+00,   0.948007D+00,   0.947951D+00,
     .   0.947901D+00,   0.947856D+00,   0.947816D+00,   0.947780D+00,
     .   0.947747D+00/

      DATA (YHI(I),I=  1, 40)/
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00/

      DATA (YHI(I),I= 41, 80)/
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.000000D+00,   0.000000D+00,   0.000000D+00,
     .   0.000000D+00,   0.139099D+02,   0.135985D+02,   0.129433D+02,
     .   0.115241D+02,   0.109099D+02,   0.105023D+02,   0.101975D+02,
     .   0.994666D+01,   0.973249D+01,   0.955072D+01,   0.938779D+01,
     .   0.926010D+01,   0.904833D+01,   0.822641D+01,   0.769471D+01,
     .   0.731795D+01,   0.702689D+01,   0.679151D+01,   0.659501D+01,
     .   0.642784D+01,   0.627994D+01,   0.615133D+01,   0.603445D+01,
     .   0.592851D+01,   0.583368D+01,   0.574713D+01,   0.566615D+01,
     .   0.559183D+01,   0.552125D+01,   0.545773D+01,   0.539717D+01/

      DATA (YHI(I),I= 81,120)/
     .   0.534079D+01,   0.528607D+01,   0.524616D+01,   0.518717D+01,
     .   0.514130D+01,   0.509733D+01,   0.505688D+01,   0.501819D+01,
     .   0.497961D+01,   0.494384D+01,   0.490920D+01,   0.487554D+01,
     .   0.484358D+01,   0.481329D+01,   0.478382D+01,   0.475522D+01,
     .   0.472591D+01,   0.470170D+01,   0.467573D+01,   0.465221D+01,
     .   0.462770D+01,   0.460557D+01,   0.458185D+01,   0.455955D+01,
     .   0.453979D+01,   0.451890D+01,   0.449816D+01,   0.447892D+01,
     .   0.446026D+01,   0.444267D+01,   0.442676D+01,   0.440697D+01,
     .   0.439013D+01,   0.437358D+01,   0.435712D+01,   0.434110D+01,
     .   0.432672D+01,   0.431267D+01,   0.429751D+01,   0.428343D+01/

      DATA (YHI(I),I=121,160)/
     .   0.427365D+01,   0.420294D+01,   0.414466D+01,   0.409214D+01,
     .   0.404533D+01,   0.400031D+01,   0.396002D+01,   0.392573D+01,
     .   0.388896D+01,   0.385755D+01,   0.382801D+01,   0.380294D+01,
     .   0.377514D+01,   0.375083D+01,   0.372935D+01,   0.370699D+01,
     .   0.368712D+01,   0.366809D+01,   0.365027D+01,   0.363543D+01,
     .   0.361720D+01,   0.358746D+01,   0.356094D+01,   0.353592D+01,
     .   0.351342D+01,   0.349311D+01,   0.347414D+01,   0.345638D+01,
     .   0.344101D+01,   0.342617D+01,   0.341113D+01,   0.339796D+01,
     .   0.338643D+01,   0.336389D+01,   0.336365D+01,   0.335364D+01,
     .   0.334409D+01,   0.333505D+01,   0.332674D+01,   0.331879D+01/

      DATA (YHI(I),I=161,200)/
     .   0.331120D+01,   0.330403D+01,   0.329771D+01,   0.329085D+01,
     .   0.328464D+01,   0.327883D+01,   0.327314D+01,   0.326792D+01,
     .   0.326288D+01,   0.325806D+01,   0.325338D+01,   0.324939D+01,
     .   0.324364D+01,   0.324075D+01,   0.323682D+01,   0.323314D+01,
     .   0.322970D+01,   0.322645D+01,   0.322304D+01,   0.321967D+01,
     .   0.321644D+01,   0.321365D+01,   0.321091D+01,   0.320820D+01,
     .   0.320591D+01,   0.320173D+01,   0.320052D+01,   0.319799D+01,
     .   0.319581D+01,   0.319467D+01,   0.319147D+01,   0.318952D+01,
     .   0.318748D+01,   0.318555D+01,   0.318376D+01,   0.318181D+01,
     .   0.318007D+01,   0.317846D+01,   0.317672D+01,   0.317517D+01/

      DATA (YHI(I),I=201,240)/
     .   0.317364D+01,   0.317217D+01,   0.317067D+01,   0.316944D+01,
     .   0.316786D+01,   0.316678D+01,   0.316526D+01,   0.316408D+01,
     .   0.316285D+01,   0.316170D+01,   0.316091D+01,   0.315915D+01,
     .   0.315835D+01,   0.315716D+01,   0.315614D+01,   0.315529D+01,
     .   0.315398D+01,   0.315332D+01,   0.315229D+01,   0.315152D+01,
     .   0.315016D+01,   0.314661D+01,   0.314304D+01,   0.314010D+01,
     .   0.313695D+01,   0.313488D+01,   0.313256D+01,   0.313050D+01,
     .   0.312871D+01,   0.312714D+01,   0.312543D+01,   0.312440D+01,
     .   0.312337D+01,   0.312226D+01,   0.312178D+01,   0.312044D+01,
     .   0.311971D+01,   0.311905D+01,   0.311837D+01,   0.311772D+01/

      DATA (YHI(I),I=241,280)/
     .   0.311728D+01,   0.311649D+01,   0.311581D+01,   0.311530D+01,
     .   0.311486D+01,   0.311454D+01,   0.311433D+01,   0.311411D+01,
     .   0.311346D+01,   0.311374D+01,   0.311388D+01,   0.311402D+01,
     .   0.311388D+01,   0.311404D+01,   0.311386D+01,   0.311430D+01,
     .   0.311434D+01,   0.311457D+01,   0.311465D+01,   0.311453D+01,
     .   0.311499D+01,   0.311419D+01,   0.311536D+01,   0.311458D+01,
     .   0.311576D+01,   0.311543D+01,   0.311621D+01,   0.311621D+01,
     .   0.311663D+01,   0.311247D+01,   0.311712D+01,   0.311809D+01,
     .   0.311924D+01,   0.311969D+01,   0.312144D+01,   0.312209D+01,
     .   0.312264D+01,   0.312359D+01,   0.312435D+01,   0.312502D+01/

      DATA (YHI(I),I=281,320)/
     .   0.312574D+01,   0.312642D+01,   0.312704D+01,   0.312763D+01,
     .   0.312803D+01,   0.312864D+01,   0.312920D+01,   0.312927D+01,
     .   0.312936D+01,   0.313034D+01,   0.313052D+01,   0.313141D+01,
     .   0.313006D+01,   0.313158D+01,   0.313209D+01,   0.313244D+01,
     .   0.313208D+01,   0.313199D+01,   0.313286D+01,   0.313380D+01,
     .   0.313381D+01,   0.313416D+01,   0.313482D+01,   0.313447D+01,
     .   0.313558D+01,   0.313581D+01,   0.313484D+01,   0.313640D+01,
     .   0.313664D+01,   0.313707D+01,   0.313714D+01,   0.313734D+01,
     .   0.313758D+01,   0.313790D+01,   0.313794D+01,   0.313833D+01,
     .   0.313845D+01,   0.313740D+01,   0.313896D+01,   0.313905D+01/

      DATA (YHI(I),I=321,360)/
     .   0.313887D+01,   0.313938D+01,   0.313952D+01,   0.313964D+01,
     .   0.313955D+01,   0.313970D+01,   0.313998D+01,   0.313997D+01,
     .   0.313899D+01,   0.313987D+01,   0.314037D+01,   0.314064D+01,
     .   0.314111D+01,   0.314169D+01,   0.314162D+01,   0.314191D+01,
     .   0.314213D+01,   0.314205D+01,   0.314228D+01,   0.314239D+01,
     .   0.314249D+01,   0.314258D+01,   0.314266D+01,   0.314273D+01,
     .   0.314279D+01,   0.314284D+01,   0.314289D+01,   0.314294D+01,
     .   0.314298D+01,   0.314301D+01,   0.314305D+01,   0.314307D+01,
     .   0.314310D+01,   0.314312D+01,   0.314314D+01,   0.314316D+01,
     .   0.314318D+01,   0.314320D+01,   0.314321D+01,   0.314322D+01/

      DATA (YHI(I),I=361,400)/
     .   0.314323D+01,   0.314325D+01,   0.314327D+01,   0.314328D+01,
     .   0.314329D+01,   0.314330D+01,   0.314330D+01,   0.314330D+01,
     .   0.314331D+01,   0.314331D+01,   0.314330D+01,   0.314330D+01,
     .   0.314330D+01,   0.314330D+01,   0.314329D+01,   0.314329D+01,
     .   0.314328D+01,   0.314328D+01,   0.314327D+01,   0.314327D+01,
     .   0.314326D+01,   0.314326D+01,   0.314325D+01,   0.314324D+01,
     .   0.314324D+01,   0.314323D+01,   0.314322D+01,   0.314321D+01,
     .   0.314321D+01,   0.314320D+01,   0.314319D+01,   0.314316D+01,
     .   0.314312D+01,   0.314309D+01,   0.314306D+01,   0.314302D+01,
     .   0.314299D+01,   0.314296D+01,   0.314293D+01,   0.314291D+01/

      DATA (YHI(I),I=401,440)/
     .   0.314289D+01,   0.314287D+01,   0.314284D+01,   0.314282D+01,
     .   0.314280D+01,   0.314278D+01,   0.314276D+01,   0.314274D+01,
     .   0.314273D+01,   0.314271D+01,   0.314269D+01,   0.314268D+01,
     .   0.314266D+01,   0.314265D+01,   0.314263D+01,   0.314262D+01,
     .   0.314260D+01,   0.314259D+01,   0.314258D+01,   0.314257D+01,
     .   0.314256D+01,   0.314253D+01,   0.314251D+01,   0.314249D+01,
     .   0.314247D+01,   0.314246D+01,   0.314244D+01,   0.314242D+01,
     .   0.314241D+01,   0.314239D+01,   0.314238D+01,   0.314237D+01,
     .   0.314235D+01,   0.314234D+01,   0.314233D+01,   0.314232D+01,
     .   0.314231D+01,   0.314230D+01,   0.314229D+01,   0.314228D+01/

      DATA (YHI(I),I=441,461)/
     .   0.314227D+01,   0.314226D+01,   0.314225D+01,   0.314224D+01,
     .   0.314223D+01,   0.314222D+01,   0.314222D+01,   0.314221D+01,
     .   0.314220D+01,   0.314220D+01,   0.314219D+01,   0.314216D+01,
     .   0.314213D+01,   0.314211D+01,   0.314208D+01,   0.314206D+01,
     .   0.314205D+01,   0.314203D+01,   0.314202D+01,   0.314200D+01,
     .   0.314198D+01/
 
      END

