/***************************************************************************
                          InDetSoftwareTutorial.h  -  Description
                             -------------------
    begin   : 10-05-2005
    authors : Edward Moyse(CERN PH-ATC)
    email   : Edward.Moyse@cern.ch
 ***************************************************************************/

#ifndef INDETSOFTWARETUTORIAL_PRIVXTOPALG_H
#define INDETSOFTWARETUTORIAL_PRIVXTOPALG_H

#include "VxVertex/RecVertex.h"
#include "GaudiKernel/Algorithm.h"
#include "TrkVertexBilloirTools/FastVertexFitter.h"
#include <string>
#include "Identifier/Identifier.h"
/* Forward declarations */
class StoreGateSvc;
class Identifier;
class AtlasDetectorID;
namespace InDetDD{
  class SCT_DetectorManager;
}
namespace AIDA {
 class IHistogram1D;
 //class IHistogram2D;
  }

namespace InDet
{
  /** A class provided as a basic framework for the UK ID software tutorial*/
  class InDetSoftwareTutorial : public Algorithm
  {
  public:
    InDetSoftwareTutorial(const std::string &name, ISvcLocator *pSvcLocator);
    virtual ~InDetSoftwareTutorial();
    StatusCode initialize();
    StatusCode finalize();
    StatusCode execute();

  protected:
    Trk::FastVertexFitter*   m_fitTool;    //!< Pointer to the base class of the fit algtools
    double        m_maxD0;      //!< Maximum d0 of tracks        
    StoreGateSvc* m_storeGate;  //!< pointer to StoreGate   
    StoreGateSvc* m_detStore;
    std::string   m_tracksName; //!< Name of track container in StoreGate

    AIDA::IHistogram1D*                    m_histo1D_Barrel_Residual;        //<! pointer to a 1 dim histogram
    AIDA::IHistogram1D*                    m_histo1D_Barrel_0_Residual;        //<! pointer to a 1 dim histogram
    AIDA::IHistogram1D*                    m_histo1D_Barrel_1_Residual;        //<! pointer to a 1 dim histogram
    AIDA::IHistogram1D*                    m_histo1D_Barrel_2_Residual;        //<! pointer to a 1 dim histogram
    AIDA::IHistogram1D*                    m_histo1D_Barrel_3_Residual;        //<! pointer to a 1 dim histogram

    AtlasDetectorID*                       m_idHelper;
const InDetDD::SCT_DetectorManager*    m_SCT_Manager; 
    void HitLoop(const Trk::Track*);
 };
}
#endif
