// ファイル名： Ch05/SolidLocator/Appli_Main.cc 
#include <iostream> 
#include "./units.inc" 
#include "./Box.hh" 
#include "./Sphere.hh" 
#include "./SolidLocator.hh" 
using namespace std; 
 
int main() { 
  SolidLocator locator = SolidLocator(); 
  { SolidPars par = {30.0*cm, 20.0*cm, 10.0*cm}; // Size: X,Y,Z 
    Solid*  pSol = new Box("Box_#1", par);  
    Point3D pos =  {1.0*m,  -1.0*m, 2.0*m};  
    locator.placeSolid(pSol, pos); 
  } 
  { SolidPars par = {25.0*cm};                   // Radius 
    Solid*  pSol = new Sphere("Sphere_#1", par); 
    Point3D pos =  {1.0*m, 1.0*m, -2.0*m};  
    locator.placeSolid(pSol, pos); 
  } 
  Point3D testPoint = {1.0*m, 1.0*m, -2.0*m};  
  vector<Solid*> inSolids = locator.isPointInSolids(testPoint); 
  for (auto val : inSolids){  
    cout << "Solids containing testpoint: "  
         << val->getSolidName() << endl;  
  } 
}
